/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.ui;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.QTAppException;
import quicktime.app.event.MouseTargetListener;
import quicktime.app.event.QTActionEvent;
import quicktime.app.event.QTActionListener;
import quicktime.app.event.QTEventCaster;
import quicktime.app.event.QTMouseEvent;
import quicktime.app.image.ImageSpec;
import quicktime.app.ui.UIElement;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.Matrix;

public abstract class QTButton
extends UIElement {
    protected ImageSpec releasedImage;
    protected ImageSpec rolloverImage;
    protected ImageSpec pressedImage;
    protected QTActionListener actionListener = null;
    private boolean pressedFlag;
    private boolean outOfBounds;
    private MouseTargetListener mouseTargetListener;

    protected QTButton(ImageSpec imageSpec, ImageSpec imageSpec2, ImageSpec imageSpec3, ImageSpec imageSpec4) throws QTException {
        this(imageSpec, imageSpec2, imageSpec3, imageSpec4, new Matrix(), 1, null);
    }

    protected QTButton(ImageSpec imageSpec, ImageSpec imageSpec2, ImageSpec imageSpec3, ImageSpec imageSpec4, Matrix matrix, int n, GraphicsMode graphicsMode) throws QTException {
        super(imageSpec, imageSpec3, matrix, n, graphicsMode);
        if (imageSpec2 == null) {
            throw new QTAppException("QTButton:released and pressed images must be specified");
        }
        this.releasedImage = imageSpec;
        this.pressedImage = imageSpec2;
        this.rolloverImage = imageSpec4;
    }

    public void released() throws QTException {
        this.pressedFlag = false;
        this.setImageOnRelease();
    }

    private void setImageOnRelease() throws QTException {
        if (this.outOfBounds) {
            this.setCurrentImage(this.releasedImage);
        } else if (this.rolloverImage != null) {
            this.setCurrentImage(this.rolloverImage);
        } else {
            this.setCurrentImage(this.releasedImage);
        }
    }

    public void setReleasedImage(ImageSpec imageSpec) throws QTException {
        if (imageSpec == null) {
            throw new QTAppException("QTButton:released image cannot be null");
        }
        this.releasedImage = imageSpec;
        this.setImageOnRelease();
    }

    public ImageSpec getReleasedImage() {
        return this.releasedImage;
    }

    public void setRolloverImage(ImageSpec imageSpec) throws QTException {
        this.rolloverImage = imageSpec;
        if (!this.pressedFlag && !this.outOfBounds && this.rolloverImage != null) {
            this.setCurrentImage(this.rolloverImage);
        }
    }

    public ImageSpec getRolloverImage() {
        return this.rolloverImage;
    }

    public void setPressedImage(ImageSpec imageSpec) throws QTException {
        if (imageSpec == null) {
            throw new QTAppException("QTButton:pressed image cannot be null");
        }
        this.pressedImage = imageSpec;
        if (this.pressedFlag && !this.outOfBounds) {
            this.setCurrentImage(this.pressedImage);
        }
    }

    public ImageSpec getPressedImage() {
        return this.pressedImage;
    }

    public void setDeactiveImage(ImageSpec imageSpec) throws QTException {
        this.deactiveImage = imageSpec;
        if (this.deactiveImage != null && !this.isActive()) {
            this.setCurrentImage(this.deactiveImage);
        }
    }

    public ImageSpec getDeactiveImage() {
        return this.deactiveImage;
    }

    public void pressed() throws QTException {
        this.pressedFlag = true;
        this.setCurrentImage(this.pressedImage);
    }

    public boolean isPressed() {
        return this.pressedFlag;
    }

    public boolean isMouseInButton() {
        return !this.outOfBounds;
    }

    public void addActionListener(QTActionListener qTActionListener) {
        this.actionListener = QTEventCaster.add(this.actionListener, qTActionListener);
    }

    public void removeActionListener(QTActionListener qTActionListener) {
        this.actionListener = QTEventCaster.remove(this.actionListener, qTActionListener);
    }

    public void addMouseTargetListener(MouseTargetListener mouseTargetListener) {
        this.mouseTargetListener = QTEventCaster.add(this.mouseTargetListener, mouseTargetListener);
    }

    public void removeMouseTargetListener(MouseTargetListener mouseTargetListener) {
        this.mouseTargetListener = QTEventCaster.remove(this.mouseTargetListener, mouseTargetListener);
    }

    protected void entered(QTMouseEvent qTMouseEvent) throws QTException {
        this.outOfBounds = false;
        if (this.pressedFlag) {
            this.setCurrentImage(this.pressedImage);
        } else if (this.rolloverImage != null) {
            this.setCurrentImage(this.rolloverImage);
        }
        if (this.mouseTargetListener != null) {
            this.mouseTargetListener.mouseTargetEntered(qTMouseEvent);
        }
    }

    protected void exited(QTMouseEvent qTMouseEvent) throws QTException {
        this.outOfBounds = true;
        this.setCurrentImage(this.releasedImage);
        if (this.mouseTargetListener != null) {
            this.mouseTargetListener.mouseTargetExited(qTMouseEvent);
        }
    }

    protected void fireAction() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new QTActionEvent(this, this.label));
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

