/*
 * Decompiled with CFR 0.152.
 */
package quicktime.io;

import com.apple.mrj.macos.toolbox.FSSpec;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.io.AliasHandle;
import quicktime.io.IODispatcher;
import quicktime.io.QTIOException;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.GraphicsImporterInfo;
import quicktime.std.movies.MovieProgress;
import quicktime.std.movies.media.DataRef;
import quicktime.std.music.SynthesizerConnections;
import quicktime.std.qtcomponents.MovieImporter;
import quicktime.std.sg.SequenceGrabber;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;
import quicktime.util.UtilException;

public final class QTFile
extends File
implements QuickTimeLib {
    private static Object linkage;
    private static boolean debug;
    public static final int[] kStandardQTFileTypes;
    public static final int kReadPermission = 256;
    public static final int kWritePermission = 512;
    public static final int kDeletePermission = 1024;
    private transient byte[] fileSpec;
    static /* synthetic */ Class class$quicktime$io$QTFile;

    public static QTFile fromGraphicsImporter(GraphicsImporter graphicsImporter) throws QTException {
        byte[] byArray = QTFile.makeFSSpec();
        int n = QTFile.GraphicsImportGetDataFile(QTObject.ID(graphicsImporter), byArray);
        StdQTException.checkError(n);
        return new QTFile(byArray);
    }

    public static GraphicsImporterInfo fromGraphicsImporter(GraphicsImporter graphicsImporter, QTFile qTFile, String string) throws QTException {
        int[] nArray = new int[1];
        byte[] byArray = QTFile.makeFSSpec();
        short[] sArray = new short[1];
        int n = QTFile.GraphicsImportDoExportImageFileDialog(QTObject.ID(graphicsImporter), qTFile != null ? qTFile.getFSSpec(true, 512) : null, string != null ? QTUtils.String2PString(string, 255) : null, 0, nArray, byArray, sArray);
        StdQTException.checkError(n);
        return new GraphicsImporterInfo(nArray[0], new QTFile(byArray), sArray[0]);
    }

    public static QTFile fromGraphicsExporterInput(GraphicsExporter graphicsExporter) throws QTException {
        byte[] byArray = QTFile.makeFSSpec();
        int n = QTFile.GraphicsExportGetInputFile(QTObject.ID(graphicsExporter), byArray);
        StdQTException.checkError(n);
        return new QTFile(byArray);
    }

    public static QTFile fromGraphicsExporterOutput(GraphicsExporter graphicsExporter) throws QTException {
        byte[] byArray = QTFile.makeFSSpec();
        int n = QTFile.GraphicsExportGetOutputFile(QTObject.ID(graphicsExporter), byArray);
        StdQTException.checkError(n);
        return new QTFile(byArray);
    }

    public static QTFile fromSequenceGrabber(SequenceGrabber sequenceGrabber) throws QTException {
        byte[] byArray = QTFile.makeFSSpec();
        int[] nArray = new int[]{0};
        int n = QTFile.SGGetDataOutput(QTObject.ID(sequenceGrabber), byArray, nArray);
        StdQTException.checkError(n);
        return new QTFile(byArray);
    }

    public static QTFile fromSynthesizerConnections(SynthesizerConnections synthesizerConnections) throws QTException {
        int n = QTFile.getIntFromArray(synthesizerConnections.getBytes(), 24);
        if (n == 0) {
            return null;
        }
        byte[] byArray = QTFile.makeFSSpec();
        QTFile.copyPointerToArray(n, 0, byArray, 0, byArray.length);
        return new QTFile(byArray);
    }

    public static void checkSecurity(String string, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            boolean bl = false;
            if ((n & 0x100) != 0) {
                securityManager.checkRead(string);
                bl = true;
            }
            if ((n & 0x200) != 0) {
                securityManager.checkWrite(string);
                bl = true;
            }
            if ((n & 0x400) != 0) {
                securityManager.checkDelete(string);
                bl = true;
            }
            if (!bl) {
                throw new SecurityException(string + ",Unknown permission request:0x" + Integer.toHexString(n));
            }
        }
    }

    public static QTFile resolveAlias(AliasHandle aliasHandle) throws QTException {
        byte[] byArray = QTFile.makeFSSpec();
        byte[] byArray2 = new byte[]{0};
        short s = QTFile.ResolveAlias(null, QTObject.ID(aliasHandle), byArray, byArray2);
        QTIOException.checkError(s, QTUtils.PString2String(byArray, 6));
        QTFile qTFile = new QTFile(byArray);
        if (System.getSecurityManager() != null) {
            try {
                QTFile.checkSecurity(qTFile.getCanonicalPath(), 256);
            }
            catch (IOException iOException) {
                throw new QTIOException(iOException.getMessage());
            }
        }
        return qTFile;
    }

    private static int getNumTypes(int[] nArray) {
        if (nArray == null) {
            return -1;
        }
        int n = nArray.length;
        if (n == 0) {
            return -1;
        }
        if (n > 4) {
            return 4;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QTFile standardGetFilePreview(int[] nArray) throws QTException {
        byte[] byArray;
        if (QTSession.isCurrentOS(4)) {
            FileDialog fileDialog = new FileDialog(new Frame(), "Open File...");
            fileDialog.show();
            if (fileDialog.getFile() == null) {
                throw new QTIOException(-128, "");
            }
            byte[] byArray2 = QTFile.path2Spec(fileDialog.getDirectory() + fileDialog.getFile(), true);
            return new QTFile(fileDialog.getDirectory() + fileDialog.getFile(), byArray2);
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            byte[] byArray3 = QTFile.makeStdFileReply();
            QTFile.StandardGetFilePreview(0, (short)QTFile.getNumTypes(nArray), nArray, byArray3);
            if (byArray3[0] == 0) {
                throw new QTIOException(-128, "");
            }
            byArray = QTFile.makeFSSpec();
            System.arraycopy(byArray3, 6, byArray, 0, byArray.length);
        }
        return new QTFile(byArray);
    }

    public QTFile(String string) {
        super(string);
    }

    public QTFile(File file) {
        this(file.getPath());
    }

    private QTFile(byte[] byArray) throws QTIOException {
        this(QTFile.spec2Path(byArray), byArray);
    }

    private QTFile(String string, byte[] byArray) {
        super(string);
        this.fileSpec = byArray;
    }

    public final byte[] getFSSpec(boolean bl, int n) throws QTIOException {
        if (this.fileSpec == null) {
            try {
                this.fileSpec = QTFile.path2Spec(this.getCanonicalPath(), bl);
            }
            catch (IOException iOException) {
                throw new QTIOException(iOException.getMessage());
            }
        }
        try {
            QTFile.checkSecurity(this.getCanonicalPath(), n);
        }
        catch (IOException iOException) {
            throw new QTIOException(iOException.getMessage());
        }
        byte[] byArray = new byte[this.fileSpec.length];
        System.arraycopy(this.fileSpec, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public void convertToMovieFile(QTFile qTFile, int n, int n2) throws QTException {
        this.convertToMovieFile(qTFile, n, n2, null, null);
    }

    public void convertToMovieFile(QTFile qTFile, int n, int n2, MovieImporter movieImporter) throws QTException {
        this.convertToMovieFile(qTFile, n, n2, movieImporter, null);
    }

    public void convertToMovieFile(QTFile qTFile, int n, int n2, MovieImporter movieImporter, MovieProgress movieProgress) throws QTException {
        byte[] byArray = this.getFSSpec(true, 256);
        byte[] byArray2 = qTFile.getFSSpec(false, 512);
        if ((n2 & Integer.MIN_VALUE) != 0) {
            try {
                QTFile.checkSecurity(qTFile.getCanonicalPath(), 1024);
            }
            catch (IOException iOException) {
                throw new QTIOException(iOException.getMessage());
            }
        }
        IODispatcher iODispatcher = null;
        int n3 = -1;
        if (movieProgress != null) {
            iODispatcher = new IODispatcher(movieProgress);
            n3 = iODispatcher.ID();
        }
        short s = QTFile.ConvertFileToMovieFile(byArray, byArray2, n, (short)-1, null, n2, QTObject.ID(movieImporter), n3, 0);
        if (iODispatcher != null) {
            iODispatcher.cleanupMethodClosure();
        }
        QTIOException.checkError(s, this.getPath() + "," + qTFile.getPath());
    }

    public void createMovieFile(int n, int n2) throws QTIOException {
        if ((n2 & Integer.MIN_VALUE) != 0) {
            try {
                QTFile.checkSecurity(this.getCanonicalPath(), 1024);
            }
            catch (IOException iOException) {
                throw new QTIOException(iOException.getMessage());
            }
        }
        short s = QTFile.CreateMovieFile(this.getFSSpec(false, 512), n, (short)-1, n2 | 0x20000000 | 0x40000000, null, null);
        QTIOException.checkError(s, this.getPath());
    }

    public void createShortcutMovieFile(int n, int n2, int n3, DataRef dataRef) throws QTException {
        if (QTSession.getQTMajorVersion() < 4) {
            throw new QTException(-50);
        }
        if ((n3 & Integer.MIN_VALUE) != 0) {
            try {
                QTFile.checkSecurity(this.getCanonicalPath(), 1024);
            }
            catch (IOException iOException) {
                throw new QTIOException(iOException.getMessage());
            }
        }
        short s = QTFile.CreateShortcutMovieFile(this.getFSSpec(false, 512), n, (short)n2, n3, QTObject.ID(dataRef), dataRef.getType());
        QTIOException.checkError(s, this.getPath());
    }

    public AliasHandle newAlias(boolean bl) throws QTException {
        return AliasHandle.fromQTFile(this, bl);
    }

    public AliasHandle relativeAlias(QTFile qTFile, boolean bl) throws QTException {
        return AliasHandle.fromTargetQTFile(qTFile, this, bl);
    }

    public QTFile resolveAlias(boolean bl) throws QTIOException {
        byte by = (byte)(bl ? 1 : 0);
        byte[] byArray = new byte[]{0};
        byte[] byArray2 = new byte[]{0};
        byte[] byArray3 = this.getFSSpec(true, 256);
        short s = QTFile.ResolveAliasFile(byArray3, by, byArray, byArray2);
        QTIOException.checkError(s, QTUtils.PString2String(byArray3, 6));
        return new QTFile(byArray3);
    }

    public boolean delete() {
        boolean bl = false;
        try {
            byte[] byArray = this.getFSSpec(true, 1024);
            short s = QTFile.DeleteMovieFile(byArray);
            QTIOException.checkError(s, this.getCanonicalPath());
            bl = true;
        }
        catch (IOException iOException) {
            throw new SecurityException(iOException.getMessage());
        }
        catch (QTException qTException) {
            return super.delete();
        }
        return bl;
    }

    private static final byte[] makeStdFileReply() {
        return new byte[QTSession.isCurrentOS(1) ? 88 : 280];
    }

    private static final byte[] makeFSSpec() {
        return new byte[QTSession.isCurrentOS(1) ? 70 : 262];
    }

    private static byte[] path2Spec(String string, boolean bl) throws QTIOException {
        if (QTSession.isCurrentOS(4)) {
            FSSpec fSSpec;
            if (QTSession.getJavaVersion() >= 65540) {
                byte[] byArray = new byte[255];
                byte[] byArray2 = new byte[255];
                try {
                    byte[] byArray3 = new byte[80];
                    byte[] byArray4 = new byte[80];
                    File file = new File(string);
                    if (file.exists()) {
                        byte[] byArray5;
                        int[] nArray = new int[1];
                        int[] nArray2 = new int[1];
                        if (QTSession.isCurrentOS(4) && EndianOrder.isNativeLittleEndian()) {
                            byte[] byArray6 = file.getAbsolutePath().getBytes("UTF-16LE");
                            byArray5 = new byte[byArray6.length];
                            System.arraycopy(byArray6, 0, byArray5, 0, byArray6.length);
                        } else {
                            byte[] byArray7 = file.getAbsolutePath().getBytes("UTF-16");
                            byArray5 = new byte[byArray7.length - 2];
                            System.arraycopy(byArray7, 2, byArray5, 0, byArray7.length - 2);
                        }
                        short s = QTFile.QTNewDataReferenceFromFullPathUnicode(byArray5, file.getAbsolutePath().length(), -1, 0, nArray, nArray2);
                        if (debug) {
                            System.err.println(file.getAbsolutePath() + " " + s + " outDataRefType[0] " + nArray2[0]);
                        }
                        if (nArray2[0] == 1634494835) {
                            byte[] byArray8 = QTFile.makeFSSpec();
                            byte[] byArray9 = new byte[]{0};
                            short s2 = QTFile.ResolveAlias(null, nArray[0], byArray, byArray9);
                        }
                    } else {
                        short s = QTFile.FSPathMakeRef(QTUtils.String2CString(file.getParent()), byArray4, null);
                        if (s == 0) {
                            int n = QTFile.FSGetCatalogInfo(byArray4, 0, 0, 0, byArray2, 0);
                            String string2 = new File(string).getAbsolutePath();
                            int n2 = string2.lastIndexOf(File.separator);
                            String string3 = string2.substring(0, n2);
                            int n3 = string3.lastIndexOf(File.separator);
                            String string4 = ':' + string2.substring(n3 + 1, n2) + ':' + string2.substring(n2 + 1, string2.length());
                            if (debug) {
                                System.err.println(n + " partialPath = " + string4);
                            }
                            short s3 = QTFile.FSMakeFSSpec(QTFile.getShortFromArray(byArray2, 0), QTFile.getIntFromArray(byArray2, 2), QTUtils.String2PString(string4, string4.length()), byArray);
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new QTIOException(throwable.getMessage());
                }
                return byArray;
            }
            try {
                fSSpec = new FSSpec(new File(string));
            }
            catch (Throwable throwable) {
                throw new QTIOException(throwable.getMessage());
            }
            return fSSpec.getBytes();
        }
        String string5 = QTFile.pathName2QT(string);
        byte[] byArray = QTUtils.String2PString(string5, 255);
        byte[] byArray10 = QTFile.makeFSSpec(byArray, bl);
        try {
            QTUtils.checkFreeMemory();
        }
        catch (UtilException utilException) {
            throw new QTIOException(-108, string);
        }
        return byArray10;
    }

    private static String spec2Path(byte[] byArray) throws QTIOException {
        String string;
        if (QTSession.isCurrentOS(1)) {
            try {
                QTUtils.checkFreeMemory();
            }
            catch (UtilException utilException) {
                throw new QTIOException(-108, "");
            }
            string = QTFile.MacFSSpec_getFullName(byArray);
        } else {
            string = QTUtils.PString2String(byArray, 6);
        }
        return string;
    }

    private static final byte[] makeFSSpec(byte[] byArray, boolean bl) throws QTIOException {
        byte[] byArray2 = QTFile.makeFSSpec();
        short s = QTFile.FSMakeFSSpec((short)0, 0, byArray, byArray2);
        if (s != 0) {
            if (s == -43) {
                if (bl) {
                    QTIOException.checkError(s, QTUtils.PString2String(byArray, 0));
                }
            } else {
                QTIOException.checkError(s, QTUtils.PString2String(byArray, 0));
            }
        }
        return byArray2;
    }

    private static String pathName2QT(String string) throws QTIOException {
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
            string = QTFile.MacFSSpec_pathName2QT(string);
            string = QTFile.cleanUpPathName(string);
            string = QTFile.MacFSSpec_checkAndResolveAlias(string);
        } else if (QTSession.isCurrentOS(2)) {
            string = string.replace('/', File.separatorChar);
        }
        return string;
    }

    private static final String cleanUpPathName(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '%') {
                String string2 = string.substring(i + 1, i + 3);
                stringBuffer.append((char)Integer.parseInt(string2, 16));
                i += 2;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return new String(stringBuffer);
    }

    private static String MacFSSpec_pathName2QT(String string) {
        if (string.charAt(0) == ':' || string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string.replace('/', ':');
    }

    private static String MacFSSpec_checkAndResolveAlias(String string) throws QTIOException {
        try {
            QTUtils.checkFreeMemory();
        }
        catch (QTException qTException) {
            throw new QTIOException(-108, string);
        }
        byte[] byArray = new byte[string.length() + 1];
        byte[] byArray2 = string.getBytes();
        int n = QTSession.isCurrentOS(1) ? byArray2.length : string.length();
        System.arraycopy(byArray2, 0, byArray, 1, byArray2.length);
        byArray[0] = (byte)n;
        byte[] byArray3 = new byte[70];
        if (QTFile.FSMakeFSSpec((short)0, 0, byArray, byArray3) == -120) {
            String string2 = string.substring(0, string.lastIndexOf(58));
            byArray2 = string.getBytes();
            System.arraycopy(byArray2, 0, byArray, 1, n);
            byArray[0] = QTSession.isCurrentOS(1) ? (byte)string2.getBytes().length : (byte)string2.length();
            QTFile.FSMakeFSSpec((short)0, 0, byArray, byArray3);
            int[] nArray = new int[]{0};
            byte[] byArray4 = new byte[]{0};
            byte[] byArray5 = new byte[]{0};
            short s = QTFile.ResolveAliasFile(byArray3, (byte)1, byArray4, byArray5);
            if (s == 0 || s == -43) {
                if (byArray5[0] != 0) {
                    String string3 = "";
                    string3 = QTFile.MacFSSpec_getFullName(byArray3);
                    string3 = QTFile.MacFSSpec_pathName2QT(string3);
                    string3 = string3 + string.substring(string.lastIndexOf(58));
                    return string3;
                }
            } else {
                throw new QTIOException(s, string);
            }
        }
        return string;
    }

    private static String MacFSSpec_getFullName(byte[] byArray) throws QTIOException {
        String string;
        CInfoPBRec cInfoPBRec = new CInfoPBRec();
        cInfoPBRec.setVRefNum(QTFile.getShortFromArray(byArray, 0));
        cInfoPBRec.setNamePtr(QTFile.getPStringAt(byArray, 6));
        cInfoPBRec.setFileDirIndex((short)-1);
        cInfoPBRec.setFileDirID(QTFile.getIntFromArray(byArray, 2));
        String string2 = new String(QTFile.getPStringAt(byArray, 6));
        int n = QTFile.getIntFromArray(byArray, 2);
        while (true) {
            string = "";
            cInfoPBRec.setFileDirID(n);
            short s = QTFile.PBGetCatInfoSync(cInfoPBRec.getBytes());
            QTIOException.checkError(s, string2);
            if (cInfoPBRec.getFileDirID() == 2) break;
            n = cInfoPBRec.getDirParID();
            string = cInfoPBRec.getName();
            string = string + File.separator;
            string2 = string = string + string2;
        }
        string = cInfoPBRec.getName();
        string = string + File.separator;
        string2 = string = string + string2;
        string = File.separator;
        string2 = string = string + string2;
        return string2;
    }

    private static String getPStringAt(byte[] byArray, int n) {
        byte by = byArray[n++];
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, n, byArray2, 0, by);
        return new String(byArray2);
    }

    private static native short QTNewDataReferenceFromFullPathUnicode(byte[] var0, int var1, int var2, int var3, int[] var4, int[] var5);

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void copyPointerToArray(int var0, int var1, byte[] var2, int var3, int var4);

    private static native int NewPtrClear(int var0);

    private static native void DisposePtr(int var0);

    private static native short FSMakeFSSpec(short var0, int var1, byte[] var2, byte[] var3);

    private static native short PBGetCatInfoSync(byte[] var0);

    private static native short ResolveAlias(byte[] var0, int var1, byte[] var2, byte[] var3);

    private static native short ResolveAliasFile(byte[] var0, byte var1, byte[] var2, byte[] var3);

    private static native short FSPathMakeRef(byte[] var0, byte[] var1, byte[] var2);

    private static native int FSGetCatalogInfo(byte[] var0, int var1, int var2, int var3, byte[] var4, int var5);

    private static native short FSMakeFSRefUnicode(byte[] var0, int var1, byte[] var2, int var3, byte[] var4);

    private static native int GraphicsImportGetDataFile(int var0, byte[] var1);

    private static native int GraphicsExportGetInputFile(int var0, byte[] var1);

    private static native int GraphicsExportGetOutputFile(int var0, byte[] var1);

    private static native int GraphicsImportDoExportImageFileDialog(int var0, byte[] var1, byte[] var2, int var3, int[] var4, byte[] var5, short[] var6);

    private static native int SGGetDataOutput(int var0, byte[] var1, int[] var2);

    private static native short ConvertFileToMovieFile(byte[] var0, byte[] var1, int var2, short var3, short[] var4, int var5, int var6, int var7, int var8);

    private static native void StandardGetFilePreview(int var0, short var1, int[] var2, byte[] var3);

    private static native short DeleteMovieFile(byte[] var0);

    private static native short CreateMovieFile(byte[] var0, int var1, short var2, int var3, short[] var4, int[] var5);

    private static native short CreateShortcutMovieFile(byte[] var0, int var1, short var2, int var3, int var4, int var5);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$io$QTFile == null ? (class$quicktime$io$QTFile = QTFile.class$("quicktime.io.QTFile")) : class$quicktime$io$QTFile);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        debug = false;
        kStandardQTFileTypes = new int[]{1299148630, 1903454566};
    }

    private static class CInfoPBRec
    extends QTByteObject
    implements PrimitivesLib {
        CInfoPBRec() {
            super(108);
        }

        short getVRefNum() {
            return this.getShortAt(22);
        }

        String getName() throws QTIOException {
            return this.getPString(this.getIntAt(18));
        }

        int getFileDirID() {
            return this.getIntAt(48);
        }

        int getDirParID() {
            return this.getIntAt(100);
        }

        void setVRefNum(short s) {
            this.setShortAt(22, s);
        }

        void setNamePtr(String string) throws QTIOException {
            if (string.length() > 255) {
                throw new QTIOException(-50, string);
            }
            int n = QTFile.NewPtrClear(256);
            if (n == 0) {
                throw new QTIOException(-108, string);
            }
            byte[] byArray = string.getBytes();
            int n2 = QTSession.isCurrentOS(1) ? byArray.length : string.length();
            CInfoPBRec.setByteInPointer(n, 0, (byte)n2);
            CInfoPBRec.copyArrayToPointer(byArray, 0, n, 1, n2);
            CInfoPBRec.setByteInPointer(n, 0, (byte)n2);
            this.setIntAt(18, n);
        }

        void setFileDirID(int n) {
            this.setIntAt(48, n);
        }

        void setFileDirIndex(short s) {
            this.setShortAt(28, s);
        }

        protected final void finalize() throws Throwable {
            if (this.getIntAt(18) != 0) {
                QTFile.DisposePtr(this.getIntAt(18));
            }
            super.finalize();
        }

        private String getPString(int n) {
            byte by = CInfoPBRec.getByteFromPointer(n, 0);
            byte[] byArray = new byte[by];
            CInfoPBRec.copyPointerToArray(n, 1, byArray, 0, by);
            return new String(byArray);
        }

        private static native void copyArrayToPointer(byte[] var0, int var1, int var2, int var3, int var4);

        private static native void copyPointerToArray(int var0, int var1, byte[] var2, int var3, int var4);

        private static native void setByteInPointer(int var0, int var1, byte var2);

        private static native byte getByteFromPointer(int var0, int var1);

        static {
            if (!QTSession.isCurrentOS(1)) {
                throw new QTRuntimeException("Class Not Required");
            }
        }
    }
}

