/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.qd.QDDimension;
import quicktime.qd.QDPoint;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;

public final class QDRect
extends QTByteObject
implements PrimitivesLib,
Cloneable {
    private static Object linkage;
    private static final int kNativeSize = 8;
    public static final int kIsRect = 8;
    public static final int kIsFixedRect = 16;
    private transient byte[] fixedRect = null;
    private static final long serialVersionUID = -5173727297383918112L;
    static /* synthetic */ Class class$quicktime$qd$QDRect;

    static boolean isObject(Object object, String string) {
        Class<?> clazz = object.getClass();
        String string2 = clazz.getName();
        while (!clazz.getName().equals("java.lang.Object")) {
            string2 = clazz.getName();
            clazz = clazz.getSuperclass();
        }
        return string2.equals(string);
    }

    public static final EndianDescriptor getEndianDescriptorFixedRect() {
        return EndianDescriptor.flipAll32;
    }

    public static final EndianDescriptor getEndianDescriptorRect() {
        return EndianDescriptor.flipAll16;
    }

    public static QDRect fromArray(byte[] byArray, int n) {
        if (n > byArray.length) {
            throw new IllegalArgumentException("Mismatch between flag and supplied rectBytes");
        }
        switch (n) {
            case 8: {
                return new QDRect(byArray, null);
            }
            case 16: {
                QDRect qDRect = new QDRect();
                qDRect.fixedRect = new byte[16];
                System.arraycopy(byArray, 0, qDRect.fixedRect, 0, 16);
                qDRect._setXI((int)qDRect.getXF());
                qDRect._setYI((int)qDRect.getYF());
                qDRect._setRightI((int)qDRect.getRightF());
                qDRect._setBottomI((int)qDRect.getBottomF());
                return qDRect;
            }
        }
        throw new IllegalArgumentException("Unknown rect format");
    }

    public QDRect() {
        super(8);
    }

    public QDRect(int n, int n2, int n3, int n4) {
        this();
        this.setX(n);
        this.setY(n2);
        this.setWidth(n3);
        this.setHeight(n4);
    }

    public QDRect(float f, float f2, float f3, float f4) {
        this();
        this.setX(f);
        this.setY(f2);
        this.setWidth(f3);
        this.setHeight(f4);
    }

    public QDRect(int n, int n2) {
        this(0, 0, n, n2);
    }

    public QDRect(float f, float f2) {
        this(0.0f, 0.0f, f, f2);
    }

    public QDRect(QDPoint qDPoint) {
        this(qDPoint.getX(), qDPoint.getY(), 0, 0);
    }

    public QDRect(Point point) {
        this(point.x, point.y, 0, 0);
    }

    public QDRect(QDDimension qDDimension) {
        this(0, 0, qDDimension.getWidth(), qDDimension.getHeight());
    }

    public QDRect(Dimension dimension) {
        this(0, 0, dimension.width, dimension.height);
    }

    public QDRect(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public QDRect(QDPoint qDPoint, QDDimension qDDimension) {
        this(qDPoint.getX(), qDPoint.getY(), qDDimension.getWidth(), qDDimension.getHeight());
    }

    public QDRect(Point point, Dimension dimension) {
        this(point.x, point.y, dimension.width, dimension.height);
    }

    private QDRect(byte[] byArray, byte[] byArray2) {
        super(byArray);
        if (byArray2 != null) {
            this.fixedRect = new byte[16];
            System.arraycopy(byArray2, 0, this.fixedRect, 0, 16);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        this.bytes = new byte[8];
        byte[] byArray = new byte[24];
        objectInputStream.read(byArray);
        for (n = 0; n < 8; n += 2) {
            QDRect.setShortInArray(this.getBytes(), n, EndianOrder.flipBigEndianToNative16(QDRect.getShortFromArray(byArray, n)));
        }
        this.fixedRect = new byte[16];
        for (n = 0; n < this.fixedRect.length; n += 4) {
            QDRect.setIntInArray(this.fixedRect, n, EndianOrder.flipBigEndianToNative32(QDRect.getIntFromArray(byArray, n + 8)));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[24];
        for (int i = 0; i < 8; i += 2) {
            QDRect.setShortInArray(byArray, i, EndianOrder.flipNativeToBigEndian16(QDRect.getShortFromArray(this.getBytes(), i)));
        }
        byte[] byArray2 = this.getFixedRect();
        for (int i = 0; i < byArray2.length; i += 4) {
            QDRect.setIntInArray(byArray, i + 8, EndianOrder.flipNativeToBigEndian32(QDRect.getIntFromArray(byArray2, i)));
        }
        objectOutputStream.write(byArray);
    }

    public byte[] getRect() {
        return this.bytes;
    }

    public byte[] getFixedRect() {
        if (this.fixedRect == null) {
            this.fixedRect = new byte[16];
            this.setX((float)this.getX());
            this.setY((float)this.getY());
            this.setWidth((float)this.getWidth());
            this.setHeight((float)this.getHeight());
        }
        return this.fixedRect;
    }

    public int getX() {
        return this.getShortAt(2);
    }

    public float getXF() {
        return this.fixedRect != null ? QTUtils.Fix2X(QDRect.getIntFromArray(this.fixedRect, 0)) : (float)this.getX();
    }

    public void setX(int n) {
        if (this.fixedRect != null) {
            this.setX((float)n);
        } else {
            this._setXI(n);
        }
    }

    public void setX(float f) {
        if (this.fixedRect == null) {
            this.fixedRect = new byte[16];
        }
        this._setXF(f);
        this._setXI((int)f);
    }

    public int getY() {
        return this.getShortAt(0);
    }

    public float getYF() {
        return this.fixedRect != null ? QTUtils.Fix2X(QDRect.getIntFromArray(this.fixedRect, 4)) : (float)this.getY();
    }

    public void setY(int n) {
        if (this.fixedRect != null) {
            this.setY((float)n);
        } else {
            this._setYI(n);
        }
    }

    public void setY(float f) {
        if (this.fixedRect == null) {
            this.fixedRect = new byte[16];
        }
        this._setYF(f);
        this._setYI((int)f);
    }

    public boolean isDifferentSize(QDRect qDRect) {
        return this.fixedRect == null && qDRect.fixedRect == null ? this.getWidth() != qDRect.getWidth() || this.getHeight() != qDRect.getHeight() : this.getWidthF() != qDRect.getWidthF() || this.getHeightF() != qDRect.getHeightF();
    }

    public boolean isDifferentOrigin(QDRect qDRect) {
        return this.fixedRect == null && qDRect.fixedRect == null ? this.getX() != qDRect.getX() || this.getY() != qDRect.getY() : this.getXF() != qDRect.getXF() || this.getYF() != qDRect.getYF();
    }

    public int getWidth() {
        return this.getRight() - this.getX();
    }

    public float getWidthF() {
        return this.fixedRect != null ? this.getRightF() - this.getXF() : (float)this.getWidth();
    }

    public void setWidth(int n) {
        if (this.fixedRect != null) {
            this.setWidth((float)n);
        } else {
            this.setRight(Math.abs(n) + this.getX());
        }
    }

    public void setWidth(float f) {
        if (this.fixedRect == null) {
            this.fixedRect = new byte[16];
        }
        this.setRight(Math.abs(f) + this.getXF());
        this.setRight(Math.abs(f) + (float)this.getX());
    }

    public int getHeight() {
        return this.getBottom() - this.getY();
    }

    public float getHeightF() {
        return this.fixedRect != null ? this.getBottomF() - this.getYF() : (float)this.getHeight();
    }

    public void setHeight(int n) {
        if (this.fixedRect != null) {
            this.setHeight((float)n);
        } else {
            this.setBottom(Math.abs(n) + this.getY());
        }
    }

    public void setHeight(float f) {
        if (this.fixedRect == null) {
            this.fixedRect = new byte[16];
        }
        this.setBottom(Math.abs(f) + this.getYF());
        this.setBottom(Math.abs(f) + (float)this.getY());
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setX(n);
        this.setY(n2);
        this.setWidth(n3);
        this.setHeight(n4);
    }

    public void reshape(float f, float f2, float f3, float f4) {
        this.setX(f);
        this.setY(f2);
        this.setWidth(f3);
        this.setHeight(f4);
    }

    public void move(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public void move(float f, float f2) {
        this.setX(f);
        this.setY(f2);
    }

    public void translate(int n, int n2) {
        this.move(this.getX() + n, this.getY() + n2);
    }

    public void translate(float f, float f2) {
        this.move(this.getXF() + f, this.getYF() + f2);
    }

    public void resize(int n, int n2) {
        this.reshape(this.getX(), this.getY(), n, n2);
    }

    public void resize(float f, float f2) {
        this.reshape(this.getXF(), this.getYF(), f, f2);
    }

    public boolean inside(int n, int n2) {
        return n >= this.getX() && n < this.getRight() && n2 >= this.getY() && n2 < this.getBottom();
    }

    public boolean inside(float f, float f2) {
        return f >= this.getXF() && f < this.getRightF() && f2 >= this.getYF() && f2 < this.getBottomF();
    }

    public boolean intersects(QDRect qDRect) {
        if (this.fixedRect != null && qDRect.fixedRect != null) {
            return !(qDRect.getRightF() < this.getXF() || qDRect.getBottomF() < this.getYF() || qDRect.getXF() > this.getRightF() || qDRect.getYF() > this.getBottomF());
        }
        return qDRect.getRight() >= this.getX() && qDRect.getBottom() >= this.getY() && qDRect.getX() <= this.getRight() && qDRect.getY() <= this.getBottom();
    }

    public QDRect intersection(QDRect qDRect) {
        if (this.fixedRect != null && qDRect.fixedRect != null) {
            float f = Math.max(this.getXF(), qDRect.getXF());
            float f2 = Math.min(this.getRightF(), qDRect.getRightF());
            float f3 = Math.max(this.getYF(), qDRect.getYF());
            float f4 = Math.min(this.getBottomF(), qDRect.getBottomF());
            return new QDRect(f, f3, f2 - f, f4 - f3);
        }
        int n = Math.max(this.getX(), qDRect.getX());
        int n2 = Math.min(this.getRight(), qDRect.getRight());
        int n3 = Math.max(this.getY(), qDRect.getY());
        int n4 = Math.min(this.getBottom(), qDRect.getBottom());
        return new QDRect(n, n3, n2 - n, n4 - n3);
    }

    public QDRect union(QDRect qDRect) {
        if (this.fixedRect != null && qDRect.fixedRect != null) {
            float f = Math.min(this.getXF(), qDRect.getXF());
            float f2 = Math.max(this.getRightF(), qDRect.getRightF());
            float f3 = Math.min(this.getYF(), qDRect.getYF());
            float f4 = Math.max(this.getBottomF(), qDRect.getBottomF());
            return new QDRect(f, f3, f2 - f, f4 - f3);
        }
        int n = Math.min(this.getX(), qDRect.getX());
        int n2 = Math.max(this.getRight(), qDRect.getRight());
        int n3 = Math.min(this.getY(), qDRect.getY());
        int n4 = Math.max(this.getBottom(), qDRect.getBottom());
        return new QDRect(n, n3, n2 - n, n4 - n3);
    }

    public void add(int n, int n2) {
        int n3 = Math.min(this.getX(), n);
        int n4 = Math.max(this.getX() + this.getWidth(), n);
        int n5 = Math.min(this.getY(), n2);
        int n6 = Math.max(this.getY() + this.getHeight(), n2);
        this.setX(n3);
        this.setY(n5);
        this.setWidth(n4 - n3);
        this.setHeight(n6 - n5);
    }

    public void add(float f, float f2) {
        float f3 = Math.min(this.getXF(), f);
        float f4 = Math.max(this.getXF() + this.getWidthF(), f);
        float f5 = Math.min(this.getYF(), f2);
        float f6 = Math.max(this.getYF() + this.getHeightF(), f2);
        this.setX(f3);
        this.setY(f5);
        this.setWidth(f4 - f3);
        this.setHeight(f6 - f5);
    }

    public void add(Point point) {
        this.add(point.x, point.y);
    }

    public void add(QDPoint qDPoint) {
        if (qDPoint.floatPt == null) {
            this.add(qDPoint.getX(), qDPoint.getY());
        } else {
            this.add(qDPoint.getXF(), qDPoint.getYF());
        }
    }

    public void grow(int n, int n2) {
        this.setX(this.getX() - n);
        this.setY(this.getY() - n2);
        this.setWidth(this.getWidth() + n * 2);
        this.setHeight(this.getHeight() + n2 * 2);
    }

    public void grow(float f, float f2) {
        this.setX(this.getXF() - f);
        this.setY(this.getYF() - f2);
        this.setWidth(this.getWidthF() + f * 2.0f);
        this.setHeight(this.getHeightF() + f2 * 2.0f);
    }

    public boolean isEmpty() {
        return this.getWidth() <= 0 || this.getHeight() <= 0;
    }

    public int hashCode() {
        return this.getX() ^ this.getY() * 37 ^ this.getWidth() * 43 ^ this.getHeight() * 47;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof QDRect) {
            QDRect qDRect = (QDRect)object;
            return qDRect.getXF() == this.getXF() && qDRect.getYF() == this.getYF() && qDRect.getRightF() == this.getRightF() && qDRect.getBottomF() == this.getBottomF();
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[x=" + this.getXF() + ",y=" + this.getYF() + ",width=" + this.getWidthF() + ",height=" + this.getHeightF() + "]";
    }

    public Object clone() {
        return this.copy();
    }

    public QDRect copy() {
        return new QDRect(this.getBytes(), this.fixedRect);
    }

    private int getRight() {
        return this.getShortAt(6);
    }

    private float getRightF() {
        return this.fixedRect != null ? QTUtils.Fix2X(QDRect.getIntFromArray(this.fixedRect, 8)) : (float)this.getRight();
    }

    private void setRight(int n) {
        if (this.fixedRect != null) {
            this.setRight((float)n);
        } else {
            this._setRightI(n);
        }
    }

    private void setRight(float f) {
        if (this.fixedRect == null) {
            this.fixedRect = new byte[16];
        }
        this._setRightF(f);
        this._setRightI((int)f);
    }

    private int getBottom() {
        return this.getShortAt(4);
    }

    private float getBottomF() {
        return this.fixedRect != null ? QTUtils.Fix2X(QDRect.getIntFromArray(this.fixedRect, 12)) : (float)this.getBottom();
    }

    private void setBottom(int n) {
        if (this.fixedRect != null) {
            this.setBottom((float)n);
        } else {
            this._setBottomI(n);
        }
    }

    private void setBottom(float f) {
        if (this.fixedRect == null) {
            this.fixedRect = new byte[16];
        }
        this._setBottomF(f);
        this._setBottomI((int)f);
    }

    private void _setXF(float f) {
        int n = QTUtils.X2Fix(f);
        QDRect.setIntInArray(this.fixedRect, 8, QDRect.getIntFromArray(this.fixedRect, 8) - QDRect.getIntFromArray(this.fixedRect, 0) + n);
        QDRect.setIntInArray(this.fixedRect, 0, n);
    }

    private void _setXI(int n) {
        this.setShortAt(6, (short)(this.getShortAt(6) - this.getShortAt(2) + n));
        this.setShortAt(2, (short)n);
    }

    private void _setYF(float f) {
        int n = QTUtils.X2Fix(f);
        QDRect.setIntInArray(this.fixedRect, 12, QDRect.getIntFromArray(this.fixedRect, 12) - QDRect.getIntFromArray(this.fixedRect, 4) + n);
        QDRect.setIntInArray(this.fixedRect, 4, n);
    }

    private void _setYI(int n) {
        this.setShortAt(4, (short)(this.getShortAt(4) - this.getShortAt(0) + n));
        this.setShortAt(0, (short)n);
    }

    private void _setRightF(float f) {
        QDRect.setIntInArray(this.fixedRect, 8, QTUtils.X2Fix(f));
    }

    private void _setRightI(int n) {
        this.setShortAt(6, (short)n);
    }

    private void _setBottomF(float f) {
        QDRect.setIntInArray(this.fixedRect, 12, QTUtils.X2Fix(f));
    }

    private void _setBottomI(int n) {
        this.setShortAt(4, (short)n);
    }

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$qd$QDRect == null ? (class$quicktime$qd$QDRect = QDRect.class$("quicktime.qd.QDRect")) : class$quicktime$qd$QDRect);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

