/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd3d.camera;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.UtilException;

public final class CameraRange
extends QTByteObject
implements Cloneable {
    public static final int kNativeSize = 8;
    static final long serialVersionUID = -4968315887114751172L;

    public static final EndianDescriptor getEndianDescriptor() {
        return EndianDescriptor.flipAll32;
    }

    public CameraRange() {
        super(8);
    }

    public CameraRange(float f, float f2) {
        this();
        this.setHither(f);
        this.setYon(f2);
    }

    private CameraRange(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[8];
        CameraRange cameraRange = new CameraRange();
        objectInputStream.read(cameraRange.getBytes());
        try {
            EndianOrder.flipBigEndianToNative(cameraRange, 0, CameraRange.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        System.arraycopy(cameraRange.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        CameraRange cameraRange = (CameraRange)this.clone();
        try {
            EndianOrder.flipNativeToBigEndian(cameraRange, 0, CameraRange.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        objectOutputStream.write(cameraRange.getBytes());
    }

    public float getHither() {
        return this.getFloatAt(0);
    }

    public float getYon() {
        return this.getFloatAt(4);
    }

    public void setHither(float f) {
        this.setFloatAt(0, f);
    }

    public void setYon(float f) {
        this.setFloatAt(4, f);
    }

    public Object clone() {
        return new CameraRange(this.getBytes());
    }

    static {
        if (QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("Unsupported OS");
        }
    }
}

