/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;

public final class DataRateParams
extends QTByteObject
implements PrimitivesLib,
Cloneable {
    private static Object linkage;
    public static final int kNativeSize = 24;
    static final long serialVersionUID = 7326971667474597100L;
    static /* synthetic */ Class class$quicktime$std$image$DataRateParams;

    public DataRateParams() {
        super(24);
    }

    public DataRateParams(int n, int n2, int n3, int n4, int n5, int n6) {
        this();
        this.setDataRate(n);
        this.setDataOverrun(n2);
        this.setFrameDuration(n3);
        this.setKeyFrameRate(n4);
        this.setMinSpatialQuality(n5);
        this.setMinTemporalQuality(n6);
    }

    private DataRateParams(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[24];
        byte[] byArray = new byte[24];
        objectInputStream.read(byArray);
        for (int i = 0; i < 24; i += 4) {
            int n = DataRateParams.getIntFromArray(byArray, i);
            int n2 = EndianOrder.flipBigEndianToNative32(n);
            DataRateParams.setIntInArray(this.getBytes(), i, n2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[24];
        for (int i = 0; i < 24; i += 4) {
            int n = DataRateParams.getIntFromArray(this.getBytes(), i);
            int n2 = EndianOrder.flipNativeToBigEndian32(n);
            DataRateParams.setIntInArray(byArray, i, n2);
        }
        objectOutputStream.write(byArray);
    }

    public int getDataRate() {
        return this.getIntAt(0);
    }

    public int getDataOverrun() {
        return this.getIntAt(4);
    }

    public int getFrameDuration() {
        return this.getIntAt(8);
    }

    public int getKeyFrameRate() {
        return this.getIntAt(12);
    }

    public int getMinSpatialQuality() {
        return this.getIntAt(16);
    }

    public int getMinTemporalQuality() {
        return this.getIntAt(20);
    }

    public void setDataRate(int n) {
        this.setIntAt(0, n);
    }

    public void setDataOverrun(int n) {
        this.setIntAt(4, n);
    }

    public void setFrameDuration(int n) {
        this.setIntAt(8, n);
    }

    public void setKeyFrameRate(int n) {
        this.setIntAt(12, n);
    }

    public void setMinSpatialQuality(int n) {
        this.setIntAt(16, n);
    }

    public void setMinTemporalQuality(int n) {
        this.setIntAt(20, n);
    }

    public Object clone() {
        return new DataRateParams(this.getBytes());
    }

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$image$DataRateParams == null ? (class$quicktime$std$image$DataRateParams = DataRateParams.class$("quicktime.std.image.DataRateParams")) : class$quicktime$std$image$DataRateParams);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

