/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.QDPoint;
import quicktime.std.StdQTException;
import quicktime.std.image.Curve;
import quicktime.std.image.GXPath;
import quicktime.std.image.NearestPointInfo;
import quicktime.std.image.PathPointInfo;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;

public final class GXPaths
extends QTByteObject
implements QuickTimeLib {
    private static Object linkage;
    private Curve comp;
    static /* synthetic */ Class class$quicktime$std$image$GXPaths;

    private static int howManyBytes(GXPath[] gXPathArray) {
        int n = 0;
        for (int i = 0; i < gXPathArray.length; ++i) {
            n += gXPathArray[i].getSize();
        }
        return n;
    }

    public GXPaths(Curve curve, GXPath[] gXPathArray) {
        super(GXPaths.howManyBytes(gXPathArray) + 4);
        this.setIntAt(0, gXPathArray.length);
        int n = 4;
        for (int i = 0; i < gXPathArray.length; ++i) {
            this.setBytesAt(n, gXPathArray[i].getSize(), gXPathArray[i].getBytes(), 0);
            n += gXPathArray[i].getSize();
        }
        this.comp = curve;
    }

    public int getContours() {
        return this.getIntAt(0);
    }

    public int countPointsInPath(int n) throws StdQTException {
        int[] nArray = new int[]{0};
        int n2 = GXPaths.CurveCountPointsInPath(QTObject.ID(this.comp), this.getBytes(), n, nArray);
        StdQTException.checkError(n2);
        return nArray[0];
    }

    public void setPathPoint(int n, int n2, QDPoint qDPoint, boolean bl) throws StdQTException {
        int n3 = GXPaths.CurveSetPathPoint(QTObject.ID(this.comp), this.getBytes(), n, n2, qDPoint.getGXPoint(), (byte)(bl ? 1 : 0));
        StdQTException.checkError(n3);
    }

    public PathPointInfo getPathPoint(int n, int n2) throws StdQTException {
        QDPoint qDPoint = new QDPoint(0.0f, 0.0f);
        byte[] byArray = new byte[1];
        int n3 = GXPaths.CurveGetPathPoint(QTObject.ID(this.comp), this.getBytes(), n, n2, qDPoint.getGXPoint(), byArray);
        StdQTException.checkError(n3);
        return new PathPointInfo(qDPoint, byArray[0] != 0);
    }

    public QDPoint[] lengthToPoint(int n, int n2) throws StdQTException {
        QDPoint qDPoint = new QDPoint(0.0f, 0.0f);
        QDPoint qDPoint2 = new QDPoint(0.0f, 0.0f);
        int n3 = GXPaths.CurveLengthToPoint(QTObject.ID(this.comp), this.getBytes(), n, n2, qDPoint.getGXPoint(), qDPoint2.getGXPoint());
        StdQTException.checkError(n3);
        QDPoint[] qDPointArray = new QDPoint[]{qDPoint, qDPoint2};
        return qDPointArray;
    }

    public long getLength(int n) throws StdQTException {
        long[] lArray = new long[]{0L};
        int n2 = GXPaths.CurveGetLength(QTObject.ID(this.comp), this.getBytes(), n, lArray);
        StdQTException.checkError(n2);
        return lArray[0];
    }

    public float getPathPointToLength(int n, int n2, QDPoint qDPoint) throws StdQTException {
        int[] nArray = new int[]{0};
        int n3 = GXPaths.CurvePathPointToLength(QTObject.ID(this.comp), this.getBytes(), n, n2, qDPoint.getGXPoint(), nArray);
        StdQTException.checkError(n3);
        return QTUtils.Fix2X(nArray[0]);
    }

    public NearestPointInfo getNearestPathPoint(QDPoint qDPoint) throws StdQTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int n = GXPaths.CurveGetNearestPathPoint(QTObject.ID(this.comp), this.getBytes(), qDPoint.getGXPoint(), nArray, nArray2, nArray3);
        StdQTException.checkError(n);
        return new NearestPointInfo(nArray[0], nArray2[0], QTUtils.Fix2X(nArray3[0]));
    }

    private static native int CurveCountPointsInPath(int var0, byte[] var1, int var2, int[] var3);

    private static native int CurveSetPathPoint(int var0, byte[] var1, int var2, int var3, byte[] var4, byte var5);

    private static native int CurveGetLength(int var0, byte[] var1, int var2, long[] var3);

    private static native int CurveGetPathPoint(int var0, byte[] var1, int var2, int var3, byte[] var4, byte[] var5);

    private static native int CurveLengthToPoint(int var0, byte[] var1, int var2, int var3, byte[] var4, byte[] var5);

    private static native int CurveGetNearestPathPoint(int var0, byte[] var1, byte[] var2, int[] var3, int[] var4, int[] var5);

    private static native int CurvePathPointToLength(int var0, byte[] var1, int var2, int var3, byte[] var4, int[] var5);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$image$GXPaths == null ? (class$quicktime$std$image$GXPaths = GXPaths.class$("quicktime.std.image.GXPaths")) : class$quicktime$std$image$GXPaths);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

