/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies.media;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.movies.media.SampleDescription;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;

public final class SoundDescription
extends SampleDescription
implements QuickTimeLib {
    private static Object linkage;
    public static final int kNativeSize = 36;
    private static EndianDescriptor ed;
    static /* synthetic */ Class class$quicktime$std$movies$media$SoundDescription;

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = SampleDescription.makeED();
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(16, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(20, 4, 1);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        EndianFlipSpec endianFlipSpec3 = new EndianFlipSpec(20, 2, 4);
        endianDescriptor.addFlipSpec(endianFlipSpec3);
        EndianFlipSpec endianFlipSpec4 = new EndianFlipSpec(32, 4, 1);
        endianDescriptor.addFlipSpec(endianFlipSpec4);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = SoundDescription.makeED();
        }
        return ed;
    }

    public SoundDescription(int n) throws QTException {
        super(36, true, n);
    }

    private SoundDescription(int n, Object object) {
        super(n, null, false);
    }

    public Object clone() {
        return new SoundDescription(this.makeAndCopyHandle(), null);
    }

    public void setVersion(int n) {
        this.setShortAt(16, (short)n);
    }

    public int getVersion() {
        return this.getShortAt(16);
    }

    public void setRevLevel(int n) {
        this.setShortAt(18, (short)n);
    }

    public int getRevLevel() {
        return this.getShortAt(18);
    }

    public void setVendor(int n) {
        this.setIntAt(20, n);
    }

    public int getVendor() {
        return this.getIntAt(20);
    }

    public void setNumberOfChannels(int n) {
        this.setNumChannels(n);
    }

    public int getNumberOfChannels() {
        return this.getNumChannels();
    }

    public void setNumChannels(int n) {
        this.setShortAt(24, (short)n);
    }

    public int getNumChannels() {
        return this.getShortAt(24);
    }

    public void setSampleSize(int n) {
        this.setShortAt(26, (short)n);
    }

    public int getSampleSize() {
        return this.getShortAt(26);
    }

    public void setCompressionID(int n) {
        this.setShortAt(28, (short)n);
    }

    public int getCompressionID() {
        return this.getShortAt(28);
    }

    public void setPacketSize(int n) {
        this.setShortAt(30, (short)n);
    }

    public int getPacketSize() {
        return this.getShortAt(30);
    }

    public void setSampleRate(float f) {
        this.setIntAt(32, QTUtils.X2UFix(f));
    }

    public float getSampleRate() {
        return QTUtils.UFix2X(this.getIntAt(32));
    }

    public int getSampleRateRounded() {
        return (int)((double)QTUtils.Fix2X(this.getIntAt(32)) + 0.5);
    }

    public String toString() {
        return this.getClass().getName() + "[format=" + QTUtils.fromOSType(this.getDataFormat()) + ",numChannels=" + this.getNumberOfChannels() + ",sampleSize=" + this.getSampleSize() + ",sampleRate=" + this.getSampleRate() + "]";
    }

    public void addExtension(QTHandleRef qTHandleRef, int n) throws QTException {
        short s = SoundDescription.AddSoundDescriptionExtension(this._ID(), QTObject.ID(qTHandleRef), n);
        StdQTException.checkError(s);
    }

    public void removeExtension(int n) throws QTException {
        short s = SoundDescription.RemoveSoundDescriptionExtension(this._ID(), n);
        StdQTException.checkError(s);
    }

    public QTHandle getExtension(int n) throws QTException {
        return QTHandle.fromSoundDescription(this, n);
    }

    private static native short AddSoundDescriptionExtension(int var0, int var1, int var2);

    private static native short RemoveSoundDescriptionExtension(int var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$movies$media$SoundDescription == null ? (class$quicktime$std$movies$media$SoundDescription = SoundDescription.class$("quicktime.std.movies.media.SoundDescription")) : class$quicktime$std$movies$media$SoundDescription);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

