/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import quicktime.std.music.InstKnob;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;

public final class InstKnobList
extends QTByteObject {
    private static final int kNativeSize = 16;

    public InstKnobList() {
        super(16);
        this.setIntAt(0, EndianOrder.flipNativeToBigEndian32(1));
        this.setKnobFlags(1);
        this.setIntAt(8, EndianOrder.flipNativeToBigEndian32(1));
        this.setIntAt(12, EndianOrder.flipNativeToBigEndian32(1));
    }

    public InstKnobList(int n, InstKnob[] instKnobArray) {
        super(8 + instKnobArray.length * 8);
        this.setIntAt(0, EndianOrder.flipNativeToBigEndian32(instKnobArray.length));
        this.setKnobFlags(n);
        for (int i = 0; i < instKnobArray.length; ++i) {
            this.setKnob(i, instKnobArray[i]);
        }
    }

    public int getKnobCount() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(0));
    }

    public int getKnobFlags() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(4));
    }

    public void setKnobFlags(int n) {
        this.setIntAt(4, EndianOrder.flipNativeToBigEndian32(n));
    }

    public void setKnob(int n, InstKnob instKnob) {
        this.setIntAt(n * 8 + 8, instKnob.getNumber());
        this.setIntAt(n * 8 + 12, instKnob.getValue());
    }

    public InstKnob getKnob(int n) {
        InstKnob instKnob = new InstKnob();
        instKnob._setNumber(this.getIntAt(n * 8 + 8));
        instKnob._setValue(this.getIntAt(n * 8 + 12));
        return instKnob;
    }
}

