/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.IntEncodedImage;
import quicktime.util.QTByteObject;
import quicktime.util.QTHandleRef;
import quicktime.util.QTPointerRef;
import quicktime.util.UtilException;

public final class QTUtils
implements QuickTimeLib {
    private static Object linkage;
    private static boolean isWin;
    private static final int kIsPointer = 1;
    private static final int kIsByteArray = 16;
    private static final int kIsIntArray = 256;
    private static final int kIsFloatArray = 4096;
    private static int kShiftModShiftMask;
    private static int kControlModShiftMask;
    private static int kCommandModShiftMask;
    private static int kOptionModShiftMask;
    static /* synthetic */ Class class$quicktime$util$QTUtils;

    private QTUtils() {
    }

    public static int convertEventModifier(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
            if ((n & 1) != 0) {
                n2 = 1 << kShiftModShiftMask;
            }
            if ((n & 2) != 0) {
                n2 |= 1 << kControlModShiftMask;
            }
            if ((n & 4) != 0) {
                n2 |= 1 << kCommandModShiftMask;
            }
            if ((n & 8) != 0) {
                n2 |= 1 << kOptionModShiftMask;
            }
        } else if (QTSession.isCurrentOS(2)) {
            if ((n & 2) != 0 && (n & 8) != 0) {
                n2 = 1 << kOptionModShiftMask;
            } else if ((n & 2) != 0) {
                n2 = 1 << kCommandModShiftMask;
            } else if ((n & 8) != 0) {
                n2 = 1 << kControlModShiftMask;
            }
            if ((n & 1) != 0) {
                n2 |= 1 << kShiftModShiftMask;
            }
        }
        return n2;
    }

    public static int convertKeyValue(int n) {
        switch (n) {
            case 10: {
                return 13;
            }
            case 37: {
                return 28;
            }
            case 39: {
                return 29;
            }
            case 38: {
                return 30;
            }
            case 40: {
                return 31;
            }
            case 36: {
                return 1;
            }
            case 35: {
                return 4;
            }
            case 33: {
                return 11;
            }
            case 34: {
                return 12;
            }
        }
        return n;
    }

    public static int X2Fix(float f) {
        return (int)(f * 65536.0f);
    }

    public static float Fix2X(int n) {
        return (float)((double)n / 65536.0);
    }

    public static int X2UFix(float f) {
        return (int)((long)(f * 65536.0f) & 0xFFFFFFFFL);
    }

    public static float UFix2X(int n) {
        return (float)((double)((long)n & 0xFFFFFFFFL) / 65536.0);
    }

    public static int X2Fract(float f) {
        return (int)(f * 1.0737418E9f);
    }

    public static float Fract2X(int n) {
        return (float)((double)n / 1.073741824E9);
    }

    public static short X2ShortFix(float f) {
        return (short)(f * 256.0f);
    }

    public static float ShortFix2X(short s) {
        return (float)((double)s / 256.0);
    }

    public static int UByte2Int(byte by) {
        return by & 0xFF;
    }

    public static int UShort2Int(short s) {
        return s & 0xFFFF;
    }

    public static long UInt2Long(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static byte[] String2CString(String string) {
        byte[] byArray = new byte[string.length() + 1];
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, 0, string.length());
        byArray[string.length()] = 0;
        return byArray;
    }

    public static byte[] String2PString(String string, int n) {
        byte[] byArray = string.getBytes();
        int n2 = QTSession.isCurrentOS(1) ? (byArray.length > n ? (n > 255 ? 255 : n) : byArray.length) : (string.length() > n ? (n > 255 ? 255 : n) : string.length());
        byte[] byArray2 = new byte[n2 + 1];
        byArray2[0] = (byte)n2;
        System.arraycopy(byArray, 0, byArray2, 1, n2);
        return byArray2;
    }

    public static String CString2String(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        byte[] byArray2 = new byte[n2 - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return new String(byArray2);
    }

    public static String PString2String(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray[n]];
        System.arraycopy(byArray, n + 1, byArray2, 0, byArray[n]);
        return new String(byArray2);
    }

    public static final int toOSType(String string) {
        while (string.length() < 4) {
            string = string + " ";
        }
        return QTUtils.toOSType(string.charAt(0), string.charAt(1), string.charAt(2), string.charAt(3));
    }

    public static final int toOSType(char c, char c2, char c3, char c4) {
        return c << 24 | (c2 & 0xFF) << 16 | (c3 & 0xFF) << 8 | c4 & 0xFF;
    }

    public static String fromOSType(int n) {
        char[] cArray = new char[]{(char)((n & 0xFF000000) >>> 24), (char)((n & 0xFF0000) >>> 16), (char)((n & 0xFF00) >>> 8), (char)(n & 0xFF)};
        return new String(cArray);
    }

    public static void reclaimMemory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        runtime.gc();
        runtime.gc();
        runtime.runFinalization();
    }

    public static void checkFreeMemory() throws UtilException {
        if (!isWin) {
            int n = QTUtils.NewHandle(131072);
            if (n == 0) {
                QTUtils.reclaimMemory();
                n = QTUtils.NewHandle(131072);
                if (n == 0) {
                    throw new UtilException(-108);
                }
            }
            QTUtils.DisposeHandle(n);
        }
    }

    public static short endianFlip16(short s) {
        return (short)(s << 8 & 0xFF00 | s >>> 8 & 0xFF);
    }

    public static int endianFlip32(int n) {
        return n << 24 & 0xFF000000 | n << 8 & 0xFF0000 | n >>> 8 & 0xFF00 | n >>> 24 & 0xFF;
    }

    public static long endianFlip64(long l) {
        return l << 56 & 0xFF00000000000000L | l << 40 & 0xFF000000000000L | l << 24 & 0xFF0000000000L | l << 8 & 0xFF00000000L | l >>> 8 & 0xFF000000L | l >>> 24 & 0xFF0000L | l >>> 40 & 0xFF00L | l >>> 56 & 0xFFL;
    }

    public static void endianFlip(Object object, int n, EndianDescriptor endianDescriptor) throws UtilException {
        QTUtils.endianFlip(object, n, object, n, endianDescriptor);
    }

    public static void endianFlip(Object object, int n, Object object2, int n2, EndianDescriptor endianDescriptor) throws UtilException {
        if (endianDescriptor == null) {
            throw new UtilException("EndianDescriptor is not specified");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (object instanceof QTPointerRef) {
            if (!(object2 instanceof QTPointerRef)) {
                throw new UtilException("src and dest must be same Type");
            }
            n3 = 1;
            n4 = ((QTPointerRef)object).getSize();
            n5 = ((QTPointerRef)object2).getSize();
        } else if (object instanceof QTHandleRef) {
            if (!(object2 instanceof QTHandleRef)) {
                throw new UtilException("src and dest must be same Type");
            }
            n3 = 1;
            n4 = ((QTHandleRef)object).getSize();
            n5 = ((QTHandleRef)object2).getSize();
            object = ((QTHandleRef)object).toQTPointer();
            object2 = ((QTHandleRef)object2).toQTPointer();
        } else if (object instanceof QTByteObject) {
            if (!(object2 instanceof QTByteObject)) {
                throw new UtilException("src and dest must be same Type");
            }
            n3 = 16;
            n4 = ((QTByteObject)object).getSize();
            n5 = ((QTByteObject)object2).getSize();
            object = ((QTByteObject)object).getBytes();
            object2 = ((QTByteObject)object2).getBytes();
        } else if (object instanceof byte[]) {
            if (!(object2 instanceof byte[])) {
                throw new UtilException("src and dest must be same Type");
            }
            n3 = 16;
            n4 = ((byte[])object).length;
            n5 = ((byte[])object2).length;
        } else if (object instanceof int[]) {
            if (!(object2 instanceof int[])) {
                throw new UtilException("src and dest must be same Type");
            }
            n3 = 256;
            n4 = ((int[])object).length;
            n5 = ((int[])object2).length;
        } else if (object instanceof IntEncodedImage) {
            if (!(object2 instanceof IntEncodedImage)) {
                throw new UtilException("src and dest must be same Type");
            }
            n3 = 256;
            n4 = ((IntEncodedImage)object).getInts().length;
            n5 = ((IntEncodedImage)object2).getInts().length;
            object = ((IntEncodedImage)object).getInts();
            object2 = ((IntEncodedImage)object2).getInts();
        } else if (object instanceof float[]) {
            if (!(object2 instanceof float[])) {
                throw new UtilException("src and dest must be same Type");
            }
            n3 = 4096;
            n4 = ((float[])object).length;
            n5 = ((float[])object2).length;
        }
        if (n3 == 0) {
            throw new UtilException("unknown format");
        }
        switch (endianDescriptor.getFormatFlag()) {
            case 0: {
                Enumeration enumeration = endianDescriptor.flipSpecs();
                block12: while (enumeration.hasMoreElements()) {
                    EndianFlipSpec endianFlipSpec = (EndianFlipSpec)enumeration.nextElement();
                    switch (endianFlipSpec.sizeFlag) {
                        case 2: {
                            int n6;
                            int n7;
                            int n8;
                            for (n8 = 0; n8 < endianFlipSpec.num; ++n8) {
                                n7 = n + n8 * 2 + endianFlipSpec.offset;
                                n6 = n2 + n8 * 2 + endianFlipSpec.offset;
                                if (n7 + 2 > n4 || n6 + 2 > n5) {
                                    throw new UtilException("Attempt to read or write beyond size");
                                }
                                QTUtils.flip16(object, n7, object2, n6, n3);
                            }
                            continue block12;
                        }
                        case 4: {
                            int n6;
                            int n7;
                            int n8;
                            for (n8 = 0; n8 < endianFlipSpec.num; ++n8) {
                                n7 = n + n8 * 4 + endianFlipSpec.offset;
                                n6 = n2 + n8 * 4 + endianFlipSpec.offset;
                                if (n7 + 4 > n4 || n6 + 4 > n5) {
                                    throw new UtilException("Attempt to read or write beyond size");
                                }
                                QTUtils.flip32(object, n7, object2, n6, n3);
                            }
                            continue block12;
                        }
                        case 8: {
                            int n6;
                            int n7;
                            int n8;
                            for (n8 = 0; n8 < endianFlipSpec.num; ++n8) {
                                n7 = n + n8 * 8 + endianFlipSpec.offset;
                                n6 = n2 + n8 * 8 + endianFlipSpec.offset;
                                if (n7 + 8 > n4 || n6 + 8 > n5) {
                                    throw new UtilException("Attempt to read or write beyond size");
                                }
                                QTUtils.flip64(object, n7, object2, n6, n3);
                            }
                            continue block12;
                        }
                    }
                    throw new UtilException("Unknown Endian Flip Spec value");
                }
                break;
            }
            case 1: {
                for (int i = 0; i < (n4 - n) / 2; ++i) {
                    int n9 = n + i * 2;
                    int n10 = n2 + i * 2;
                    if (n9 + 2 > n4 || n10 + 2 > n5) {
                        throw new UtilException("Attempt to read or write beyond size");
                    }
                    QTUtils.flip16(object, n9, object2, n10, n3);
                }
                break;
            }
            case 16: {
                for (int i = 0; i < (n4 - n) / 4; ++i) {
                    int n11 = n + i * 4;
                    int n12 = n2 + i * 4;
                    if (n11 + 4 > n4 || n12 + 4 > n5) {
                        throw new UtilException("Attempt to read or write beyond size");
                    }
                    QTUtils.flip32(object, n11, object2, n12, n3);
                }
                break;
            }
            case 256: {
                for (int i = 0; i < (n4 - n) / 8; ++i) {
                    int n13 = n + i * 8;
                    int n14 = n2 + i * 8;
                    if (n13 + 8 > n4 || n14 + 8 > n5) {
                        throw new UtilException("Attempt to read or write beyond size");
                    }
                    QTUtils.flip64(object, n13, object2, n14, n3);
                }
                break;
            }
            case 4096: {
                break;
            }
            default: {
                throw new UtilException("Unknown Format flag");
            }
        }
    }

    private static void flip16(Object object, int n, Object object2, int n2, int n3) throws UtilException {
        switch (n3) {
            case 1: {
                short s = QTUtils.getShortFromPointer(QTObject.ID((QTPointerRef)object), n);
                s = QTUtils.endianFlip16(s);
                QTUtils.setShortInPointer(QTObject.ID((QTPointerRef)object2), n2, s);
                break;
            }
            case 16: {
                short s = QTUtils.getShortFromArray((byte[])object, n);
                s = QTUtils.endianFlip16(s);
                QTUtils.setShortInArray((byte[])object2, n2, s);
                break;
            }
            case 256: {
                short s = QTUtils.getShortFromArray((int[])object, n);
                s = QTUtils.endianFlip16(s);
                QTUtils.setShortInArray((int[])object2, n2, s);
                break;
            }
            case 4096: {
                short s = QTUtils.getShortFromArray((float[])object, n);
                s = QTUtils.endianFlip16(s);
                QTUtils.setShortInArray((float[])object2, n2, s);
                break;
            }
            default: {
                throw new UtilException("Unknown Format");
            }
        }
    }

    private static void flip32(Object object, int n, Object object2, int n2, int n3) throws UtilException {
        switch (n3) {
            case 1: {
                int n4 = QTUtils.getIntFromPointer(QTObject.ID((QTPointerRef)object), n);
                n4 = QTUtils.endianFlip32(n4);
                QTUtils.setIntInPointer(QTObject.ID((QTPointerRef)object2), n2, n4);
                break;
            }
            case 16: {
                int n5 = QTUtils.getIntFromArray((byte[])object, n);
                n5 = QTUtils.endianFlip32(n5);
                QTUtils.setIntInArray((byte[])object2, n2, n5);
                break;
            }
            case 256: {
                int n6 = QTUtils.getIntFromArray((int[])object, n);
                n6 = QTUtils.endianFlip32(n6);
                QTUtils.setIntInArray((int[])object2, n2, n6);
                break;
            }
            case 4096: {
                int n7 = QTUtils.getIntFromArray((float[])object, n);
                n7 = QTUtils.endianFlip32(n7);
                QTUtils.setIntInArray((float[])object2, n2, n7);
                break;
            }
            default: {
                throw new UtilException("Unknown Format");
            }
        }
    }

    private static void flip64(Object object, int n, Object object2, int n2, int n3) throws UtilException {
        switch (n3) {
            case 1: {
                long l = QTUtils.getLongFromPointer(QTObject.ID((QTPointerRef)object), n);
                l = QTUtils.endianFlip64(l);
                QTUtils.setLongInPointer(QTObject.ID((QTPointerRef)object2), n2, l);
                break;
            }
            case 16: {
                long l = QTUtils.getLongFromArray((byte[])object, n);
                l = QTUtils.endianFlip64(l);
                QTUtils.setLongInArray((byte[])object2, n2, l);
                break;
            }
            case 256: {
                long l = QTUtils.getLongFromArray((int[])object, n);
                l = QTUtils.endianFlip64(l);
                QTUtils.setLongInArray((int[])object2, n2, l);
                break;
            }
            case 4096: {
                long l = QTUtils.getLongFromArray((float[])object, n);
                l = QTUtils.endianFlip64(l);
                QTUtils.setLongInArray((float[])object2, n2, l);
                break;
            }
            default: {
                throw new UtilException("Unknown Format");
            }
        }
    }

    static void doBoundsChecks(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n + n3 * n4 > n2 || n5 + n3 > n6 || n < 0 || n5 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static native void BlockMove(int var0, int var1, int var2);

    private static native int NewHandle(int var0);

    private static native void DisposeHandle(int var0);

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native short getShortFromArray(int[] var0, int var1);

    private static native short getShortFromArray(float[] var0, int var1);

    private static native short getShortFromPointer(int var0, int var1);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    private static native void setShortInArray(int[] var0, int var1, short var2);

    private static native void setShortInArray(float[] var0, int var1, short var2);

    private static native void setShortInPointer(int var0, int var1, short var2);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(int[] var0, int var1);

    private static native int getIntFromArray(float[] var0, int var1);

    private static native int getIntFromPointer(int var0, int var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native void setIntInArray(int[] var0, int var1, int var2);

    private static native void setIntInArray(float[] var0, int var1, int var2);

    private static native void setIntInPointer(int var0, int var1, int var2);

    private static native long getLongFromArray(byte[] var0, int var1);

    private static native long getLongFromArray(int[] var0, int var1);

    private static native long getLongFromArray(float[] var0, int var1);

    private static native long getLongFromPointer(int var0, int var1);

    private static native void setLongInArray(byte[] var0, int var1, long var2);

    private static native void setLongInArray(int[] var0, int var1, long var2);

    private static native void setLongInArray(float[] var0, int var1, long var2);

    private static native void setLongInPointer(int var0, int var1, long var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$util$QTUtils == null ? (class$quicktime$util$QTUtils = QTUtils.class$("quicktime.util.QTUtils")) : class$quicktime$util$QTUtils);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        isWin = !QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        kShiftModShiftMask = 9;
        kControlModShiftMask = 12;
        kCommandModShiftMask = 8;
        kOptionModShiftMask = 11;
    }
}

