/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.util.EndianDescriptor;
import quicktime.util.QTByteObject;

public final class QTVRCubicView
extends QTByteObject
implements Cloneable {
    private static final int kNativeSize = 36;
    private static EndianDescriptor ed;
    static final long serialVersionUID = -3293127487969383255L;

    public QTVRCubicView() {
        super(36);
    }

    public QTVRCubicView(byte[] byArray) throws QTException {
        super(byArray);
        if (byArray.length != 36) {
            throw new QTException(-50);
        }
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = new EndianDescriptor(16);
        }
        return ed;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[36];
        QTVRCubicView qTVRCubicView = new QTVRCubicView();
        objectInputStream.read(qTVRCubicView.getBytes());
        System.arraycopy(qTVRCubicView.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRCubicView qTVRCubicView = (QTVRCubicView)this.clone();
        objectOutputStream.write(qTVRCubicView.getBytes());
    }

    protected Object clone() {
        try {
            return new QTVRCubicView(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    public float getMinPan() {
        return this.getFloatAt(0);
    }

    public void setMinPan(float f) {
        this.setFloatAt(0, f);
    }

    public float getMaxPan() {
        return this.getFloatAt(4);
    }

    public void setMaxPan(float f) {
        this.setFloatAt(4, f);
    }

    public float getMinTilt() {
        return this.getFloatAt(8);
    }

    public void setMinTilt(float f) {
        this.setFloatAt(8, f);
    }

    public float getMaxTilt() {
        return this.getFloatAt(12);
    }

    public void setMaxTilt(float f) {
        this.setFloatAt(12, f);
    }

    public float getMinFieldOfView() {
        return this.getFloatAt(16);
    }

    public void setMinFieldOfView(float f) {
        this.setFloatAt(16, f);
    }

    public float getMaxFieldOfView() {
        return this.getFloatAt(20);
    }

    public void setMaxFieldOfView(float f) {
        this.setFloatAt(20, f);
    }

    public float getDefaultPan() {
        return this.getFloatAt(24);
    }

    public void setDefaultPan(float f) {
        this.setFloatAt(24, f);
    }

    public float getDefaultTilt() {
        return this.getFloatAt(28);
    }

    public void setDefaultTilt(float f) {
        this.setFloatAt(28, f);
    }

    public float getDefaultFieldOfView() {
        return this.getFloatAt(32);
    }

    public void setDefaultFieldOfView(float f) {
        this.setFloatAt(32, f);
    }

    public String toString() {
        return this.getClass().getName() + "[minPan=" + this.getMinPan() + ",maxPan=" + this.getMaxPan() + ",minTilt=" + this.getMinTilt() + ",maxTilt" + this.getMaxTilt() + ",minFieldOfView" + this.getMinFieldOfView() + ",maxFieldOfView" + this.getMaxFieldOfView() + ",defaultPan" + this.getDefaultPan() + ",defaultTilt" + this.getDefaultTilt() + ",defaultFieldOfView" + this.getDefaultFieldOfView() + "]";
    }
}

