/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.QTUtils;
import quicktime.vr.QTVRAtom;

public final class QTVRHotSpotInfo
extends QTVRAtom {
    private static final int kNativeSize = 68;
    static final long serialVersionUID = -7062349173192562621L;
    private static EndianDescriptor ed;

    public QTVRHotSpotInfo() {
        super(68);
    }

    public QTVRHotSpotInfo(byte[] byArray) throws QTException {
        super(byArray, 68);
    }

    protected int getNativeSize() {
        return 68;
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[68];
        QTVRHotSpotInfo qTVRHotSpotInfo = new QTVRHotSpotInfo();
        objectInputStream.read(qTVRHotSpotInfo.getBytes());
        System.arraycopy(qTVRHotSpotInfo.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRHotSpotInfo qTVRHotSpotInfo = (QTVRHotSpotInfo)this.clone();
        objectOutputStream.write(qTVRHotSpotInfo.getBytes());
    }

    public Object clone() {
        try {
            return new QTVRHotSpotInfo(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = new EndianDescriptor(0);
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(0, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(4, 4, 16);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = QTVRHotSpotInfo.makeED();
        }
        return ed;
    }

    public int getHotSpotType() {
        return this.getIntAt(4);
    }

    public void setHotSpotType(int n) {
        this.setIntAt(4, n);
    }

    public void setHotSpotType(String string) {
        this.setIntAt(4, QTUtils.toOSType(string));
    }

    public int getNameAtomID() {
        return this.getIntAt(8);
    }

    public void setNameAtomID(int n) {
        this.setIntAt(8, n);
    }

    public int getCommentAtomID() {
        return this.getIntAt(12);
    }

    public void setCommentAtomID(int n) {
        this.setIntAt(12, n);
    }

    public int getMouseOverCursorID() {
        return this.getIntAt(16);
    }

    public void setMouseOverCursorID(int n) {
        this.setIntAt(16, n);
    }

    public int getMouseDownCursorID() {
        return this.getIntAt(20);
    }

    public void setMouseDownCursorID(int n) {
        this.setIntAt(20, n);
    }

    public int getMouseUpCursorID() {
        return this.getIntAt(24);
    }

    public void setMouseUpCursorID(int n) {
        this.setIntAt(24, n);
    }

    public float getBestPan() {
        return this.getFloatAt(28);
    }

    public void setBestPan(float f) {
        this.setFloatAt(28, f);
    }

    public float getBestTilt() {
        return this.getFloatAt(32);
    }

    public void setBestTilt(float f) {
        this.setFloatAt(32, f);
    }

    public float getBestFOV() {
        return this.getFloatAt(36);
    }

    public void setBestFOV(float f) {
        this.setFloatAt(36, f);
    }

    public QDPoint getBestViewCenter() {
        return new QDPoint(this.getFloatAt(40), this.getFloatAt(44));
    }

    public void setBestViewCenter(QDPoint qDPoint) {
        this.setFloatAt(40, qDPoint.getXF());
        this.setFloatAt(44, qDPoint.getYF());
    }

    public QDRect getHotSpotRect() {
        return new QDRect(this.getIntAt(50), this.getIntAt(48), this.getIntAt(54) - this.getIntAt(50), this.getIntAt(52) - this.getIntAt(48));
    }

    public void setHotSpotRect(QDRect qDRect) {
        this.setIntAt(48, qDRect.getY());
        this.setIntAt(50, qDRect.getX());
        this.setIntAt(52, qDRect.getY() + qDRect.getHeight());
        this.setIntAt(54, qDRect.getX() + qDRect.getWidth());
    }

    public int getFlags() {
        return this.getIntAt(56);
    }

    public void setFlags(int n) {
        this.setIntAt(56, n);
    }

    public void setReserved1(int n) {
        this.setIntAt(60, n);
    }

    public int getReserved1() {
        return this.getIntAt(60);
    }

    public void setReserved2(int n) {
        this.setIntAt(64, n);
    }

    public int getReserved2() {
        return this.getIntAt(64);
    }

    public String toString() {
        return this.getClass().getName() + "[hotSpotType=" + QTUtils.fromOSType(this.getHotSpotType()) + ",nameAtomID=" + this.getNameAtomID() + ",commentAtomID=" + this.getCommentAtomID() + ",bestPan" + this.getBestPan() + ",bestTilt" + this.getBestTilt() + ",bestFOV" + this.getBestFOV() + ",bestViewCenter" + this.getBestViewCenter() + ",hotSpotRect" + this.getHotSpotRect() + ",flags" + this.getFlags() + "]";
    }
}

