/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import quicktime.QTException;
import quicktime.util.QTPointerRef;

public final class QTVRString
extends QTPointerRef {
    public QTVRString(String string) throws QTException {
        super(4 + string.length(), true);
        this.setShortAt(0, (short)0);
        this.setShortAt(2, (short)string.length());
        System.arraycopy(string.getBytes(), 0, this.getBytes(), 4, string.length());
    }

    public QTVRString(byte[] byArray) throws QTException {
        super(byArray.length, true);
        if (byArray.length < 4) {
            throw new QTException(-50);
        }
        short s = (short)(((short)byArray[2] << 8) + (short)byArray[3]);
        if (4 + s != byArray.length) {
            throw new QTException(-50);
        }
        System.arraycopy(byArray, 0, this.getBytes(), 0, byArray.length);
    }

    public short getStringUsage() {
        return this.getShortAt(0);
    }

    public void setStringUsage(short s) {
        this.setShortAt(0, s);
    }

    public short getStringLength() {
        return this.getShortAt(2);
    }

    public String getString() {
        short s = this.getShortAt(2);
        byte[] byArray = new byte[s];
        this.getBytesAt(4, s, byArray, 0);
        return new String(byArray);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getString() + "]";
    }
}

