/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.TransformFilter;
import com.jhlabs.math.Noise;
import java.awt.Rectangle;

public class RippleFilter
extends TransformFilter {
    public static final int SINE = 0;
    public static final int SAWTOOTH = 1;
    public static final int TRIANGLE = 2;
    public static final int NOISE = 3;
    private float xAmplitude = 5.0f;
    private float yAmplitude = 0.0f;
    private float xWavelength = 16.0f;
    private float yWavelength = 16.0f;
    private int waveType;

    public void setXAmplitude(float f) {
        this.xAmplitude = f;
    }

    public float getXAmplitude() {
        return this.xAmplitude;
    }

    public void setXWavelength(float f) {
        this.xWavelength = f;
    }

    public float getXWavelength() {
        return this.xWavelength;
    }

    public void setYAmplitude(float f) {
        this.yAmplitude = f;
    }

    public float getYAmplitude() {
        return this.yAmplitude;
    }

    public void setYWavelength(float f) {
        this.yWavelength = f;
    }

    public float getYWavelength() {
        return this.yWavelength;
    }

    public void setWaveType(int n) {
        this.waveType = n;
    }

    public int getWaveType() {
        return this.waveType;
    }

    @Override
    protected void transformSpace(Rectangle rectangle) {
    }

    @Override
    protected void transformInverse(int n, int n2, float[] fArray) {
        float f;
        float f2;
        float f3 = (float)n2 / this.xWavelength;
        float f4 = (float)n / this.yWavelength;
        switch (this.waveType) {
            default: {
                f2 = (float)Math.sin(f3);
                f = (float)Math.sin(f4);
                break;
            }
            case 1: {
                f2 = ImageMath.mod(f3, 1.0f);
                f = ImageMath.mod(f4, 1.0f);
                break;
            }
            case 2: {
                f2 = ImageMath.triangle(f3);
                f = ImageMath.triangle(f4);
                break;
            }
            case 3: {
                f2 = Noise.noise1(f3);
                f = Noise.noise1(f4);
            }
        }
        fArray[0] = (float)n + this.xAmplitude * f2;
        fArray[1] = (float)n2 + this.yAmplitude * f;
    }

    public String toString() {
        return "Distort/Ripple...";
    }
}

