/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;

public class CheckerboardPainter
extends AbstractPainter<Object> {
    private transient Paint checkerPaint;
    private Paint darkPaint = new Color(204, 204, 204);
    private Paint lightPaint = Color.WHITE;
    private double squareSize = 8.0;

    public CheckerboardPainter() {
    }

    public CheckerboardPainter(Paint paint, Paint paint2) {
        this(paint, paint2, 8.0);
    }

    public CheckerboardPainter(Paint paint, Paint paint2, double d) {
        this.darkPaint = paint;
        this.lightPaint = paint2;
        this.squareSize = d;
    }

    public void setSquareSize(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        double d2 = this.getSquareSize();
        this.squareSize = d;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("squareSize", d2, this.getSquareSize());
    }

    public double getSquareSize() {
        return this.squareSize;
    }

    public void setDarkPaint(Paint paint) {
        Paint paint2 = this.getDarkPaint();
        this.darkPaint = paint;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("darkPaint", paint2, this.getDarkPaint());
    }

    public Paint getDarkPaint() {
        return this.darkPaint;
    }

    public void setLightPaint(Paint paint) {
        Paint paint2 = this.getLightPaint();
        this.lightPaint = paint;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("lightPaint", paint2, this.getLightPaint());
    }

    public Paint getLightPaint() {
        return this.lightPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Paint getCheckerPaint(Object object) {
        if (this.checkerPaint == null) {
            double d = this.getSquareSize();
            int n = (int)(d * 2.0);
            BufferedImage bufferedImage = new BufferedImage(n, n, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                Paint paint = this.getLightPaint();
                if (paint == null && object instanceof JComponent) {
                    paint = ((JComponent)object).getForeground();
                }
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, n, n);
                paint = this.getDarkPaint();
                if (paint == null && object instanceof JComponent) {
                    paint = ((JComponent)object).getBackground();
                }
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, (int)(d - 1.0), (int)(d - 1.0));
                graphics2D.fillRect((int)d, (int)d, (int)d - 1, (int)d - 1);
            }
            finally {
                graphics2D.dispose();
            }
            this.checkerPaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        return this.checkerPaint;
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, Object object, int n, int n2) {
        graphics2D.setPaint(this.getCheckerPaint(object));
        graphics2D.fillRect(0, 0, n, n2);
    }
}

