/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class WindowUtils {
    private static final Logger LOG = Logger.getLogger(WindowUtils.class.getName());

    private WindowUtils() {
    }

    public static Point getPointForCentering(Window window) {
        Rectangle rectangle = WindowUtils.getUsableDeviceBounds(window);
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = window.getWidth();
        int n4 = window.getHeight();
        return new Point((n - n3) / 2 + rectangle.x, (n2 - n4) / 2 + rectangle.y);
    }

    private static Rectangle getUsableDeviceBounds(Window window) {
        Window window2 = window.getOwner();
        GraphicsConfiguration graphicsConfiguration = null;
        graphicsConfiguration = window2 == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : window2.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle = graphicsConfiguration.getBounds();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static Point getPointForCentering(JInternalFrame jInternalFrame) {
        try {
            GraphicsDevice[] graphicsDeviceArray;
            Point point = MouseInfo.getPointerInfo().getLocation();
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
                if (point.x < rectangle.x || point.y < rectangle.y || point.x > rectangle.x + rectangle.width || point.y > rectangle.y + rectangle.height) continue;
                int n = rectangle.width;
                int n2 = rectangle.height;
                int n3 = jInternalFrame.getWidth();
                int n4 = jInternalFrame.getHeight();
                return new Point((n - n3) / 2 + rectangle.x, (n2 - n4) / 2 + rectangle.y);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getLocalizedMessage() + " - this can occur do to a Security exception in sandboxed apps");
        }
        return new Point(0, 0);
    }

    public static Point getPointForStaggering(Window window) {
        Point point = window.getLocation();
        Insets insets = window.getInsets();
        point.x += insets.top;
        point.y += insets.top;
        return point;
    }

    public static Window findWindow(Component component) {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return WindowUtils.findWindow(component.getParent());
    }

    public static List<Component> getAllComponents(Container container) {
        Component[] componentArray = container.getComponents();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : componentArray) {
            arrayList.add(component);
            if (!(component instanceof Container)) continue;
            arrayList.addAll(WindowUtils.getAllComponents((Container)component));
        }
        return arrayList;
    }

    public static void setMinimumSizeManager(Window window, int n, int n2) {
        ComponentListener[] componentListenerArray = window.getComponentListeners();
        ComponentListener componentListener = null;
        for (ComponentListener componentListener2 : componentListenerArray) {
            if (!(componentListener2 instanceof MinSizeComponentListener)) continue;
            componentListener = componentListener2;
            break;
        }
        if (componentListener == null) {
            window.addComponentListener(new MinSizeComponentListener(window, n, n2));
        } else {
            ((MinSizeComponentListener)componentListener).resetSizes(n, n2);
        }
    }

    public static class MinSizeComponentListener
    extends ComponentAdapter {
        private Window window;
        private int minHeight;
        private int minWidth;

        MinSizeComponentListener(Window window, int n, int n2) {
            this.window = window;
            this.resetSizes(n, n2);
        }

        public void resetSizes(int n, int n2) {
            this.minWidth = n;
            this.minHeight = n2;
            this.adjustIfNeeded(this.window);
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.adjustIfNeeded((Window)componentEvent.getComponent());
        }

        private void adjustIfNeeded(final Window window) {
            boolean bl = false;
            int n = window.getWidth();
            int n2 = window.getHeight();
            if (n < this.minWidth) {
                n = this.minWidth;
                bl = true;
            }
            if (n2 < this.minHeight) {
                n2 = this.minHeight;
                bl = true;
            }
            if (bl) {
                final int n3 = n;
                final int n4 = n2;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        window.setSize(n3, n4);
                    }
                });
            }
        }
    }
}

