/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.Cursor;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import pixelitor.Build;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.ImageComponent;
import pixelitor.InternalImageFrame;
import pixelitor.PixelitorWindow;
import pixelitor.filters.comp.CompositionUtils;
import pixelitor.filters.gui.ResizePanel;
import pixelitor.history.History;
import pixelitor.layers.Layer;
import pixelitor.layers.LayerChangeListener;
import pixelitor.menus.SelectionActions;
import pixelitor.menus.ZoomMenu;
import pixelitor.selection.Selection;
import pixelitor.tools.Symmetry;
import pixelitor.tools.Tool;
import pixelitor.tools.Tools;
import pixelitor.utils.AppPreferences;
import pixelitor.utils.GUIUtils;
import pixelitor.utils.ImageSwitchListener;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.debug.AppNode;

public final class AppLogic {
    private static Collection<ImageSwitchListener> imageSwitchListeners = new ArrayList<ImageSwitchListener>();
    private static Collection<LayerChangeListener> layerChangeListeners = new ArrayList<LayerChangeListener>();
    private static int numFramesOpen = 0;
    private static List<ImageComponent> imageComponents = new ArrayList<ImageComponent>();
    public static ImageComponent activeImageComponent;

    private AppLogic() {
    }

    public static void addImageComponent(ImageComponent imageComponent) {
        imageComponents.add(imageComponent);
    }

    public static void addImageChangeListener(ImageSwitchListener imageSwitchListener) {
        imageSwitchListeners.add(imageSwitchListener);
    }

    private static boolean thereAreUnsavedChanges() {
        for (ImageComponent imageComponent : imageComponents) {
            if (!imageComponent.getComp().isDirty()) continue;
            return true;
        }
        return false;
    }

    private static void allImagesAreClosed() {
        AppLogic.setActiveImageComponent(null, false);
        for (ImageSwitchListener imageSwitchListener : imageSwitchListeners) {
            imageSwitchListener.noOpenImageAnymore();
        }
        History.allImagesAreClosed();
        SelectionActions.setEnabled(false);
        PixelitorWindow.getInstance().setTitle(Build.getPixelitorWindowFixTitle());
    }

    public static void activeImageHasChanged(ImageComponent imageComponent) {
        AppLogic.setActiveImageComponent(imageComponent, false);
        Composition composition = imageComponent.getComp();
        for (ImageSwitchListener imageSwitchListener : imageSwitchListeners) {
            imageSwitchListener.activeCompositionHasChanged(composition);
        }
        Layer layer = composition.getActiveLayer();
        AppLogic.activeLayerChanged(layer);
        SelectionActions.setEnabled(composition.hasSelection());
        ZoomMenu.INSTANCE.zoomChanged(imageComponent.getZoomLevel());
        AppLogic.activeCompositionDimensionsChanged(composition);
        PixelitorWindow.getInstance().setTitle(imageComponent.getComp().getName() + " - " + Build.getPixelitorWindowFixTitle());
    }

    public static void activeCompositionDimensionsChanged(Composition composition) {
        Symmetry.setCompositionSize(composition.getCanvasWidth(), composition.getCanvasHeight());
    }

    public static void imageClosed(ImageComponent imageComponent) {
        imageComponents.remove(imageComponent);
        if (--numFramesOpen == 0) {
            AppLogic.allImagesAreClosed();
        }
        AppLogic.setNewImageAsActiveIfNecessary();
    }

    public static void newImageOpened() {
        ++numFramesOpen;
        for (ImageSwitchListener imageSwitchListener : imageSwitchListeners) {
            imageSwitchListener.newImageOpened();
        }
    }

    public static List<ImageComponent> getImageComponents() {
        return imageComponents;
    }

    private static void setNewImageAsActiveIfNecessary() {
        if (!imageComponents.isEmpty()) {
            boolean bl = false;
            for (ImageComponent imageComponent : imageComponents) {
                if (imageComponent != activeImageComponent) continue;
                bl = true;
                break;
            }
            if (!bl) {
                AppLogic.setActiveImageComponent(imageComponents.get(0), true);
            }
        }
    }

    public static ImageComponent getActiveImageComponent() {
        return activeImageComponent;
    }

    public static Composition getActiveComp() {
        if (activeImageComponent != null) {
            return activeImageComponent.getComp();
        }
        return null;
    }

    public static Layer getActiveLayer() {
        return AppLogic.getActiveComp().getActiveLayer();
    }

    public static void setStatusMessage(String string) {
        PixelitorWindow.getInstance().setStatusBarMessage(string);
    }

    public static void setCurrentTool(Tool tool) {
        Tools.setCurrentTool(tool);
        AppLogic.setStatusMessage(tool.getName() + " Tool: " + tool.getToolMessage());
    }

    public static int getNrOfOpenImages() {
        return imageComponents.size();
    }

    public static BufferedImage getActiveCompositeImage() {
        Composition composition = AppLogic.getActiveComp();
        if (composition != null) {
            return composition.getCompositeImage();
        }
        return null;
    }

    public static void addLayerChangeListener(LayerChangeListener layerChangeListener) {
        layerChangeListeners.add(layerChangeListener);
    }

    public static void activeCompLayerCountChanged(Composition composition, int n) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.activeCompLayerCountChanged(composition, n);
        }
    }

    public static void activeLayerChanged(Layer layer) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.activeLayerChanged(layer);
        }
    }

    public static void layerOrderChanged(Composition composition) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.layerOrderChanged(composition);
        }
    }

    public static void cropActiveImage() {
        try {
            Composition composition = AppLogic.getActiveComp();
            Selection selection = composition.getSelection();
            if (selection != null) {
                CompositionUtils.cropImage(composition, selection);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
    }

    public static void resizeActiveImage() {
        try {
            Composition composition = AppLogic.getActiveComp();
            ResizePanel.showInDialog(composition);
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
    }

    public static void showDebugAppDialog() {
        AppNode appNode = new AppNode();
        String string = "Pixelitor Debug";
        JTree jTree = new JTree(appNode);
        String string2 = appNode.toDetailedString();
        GUIUtils.showTextDialog(jTree, string, string2);
    }

    public static void exitApp() {
        if (AppLogic.thereAreUnsavedChanges()) {
            int n = JOptionPane.showConfirmDialog(null, "There are unsaved changes. Are you sure you want to exit?", "Confirmation", 0, 2);
            if (n == 0) {
                AppLogic.savePrefsAndExit();
            }
        } else {
            AppLogic.savePrefsAndExit();
        }
    }

    private static void savePrefsAndExit() {
        AppPreferences.savePreferencesBeforeExit();
        System.exit(0);
    }

    public static void setToolCursor(Cursor cursor) {
        for (ImageComponent imageComponent : imageComponents) {
            imageComponent.setCursor(cursor);
        }
    }

    public static void debugImage(BufferedImage bufferedImage) {
        AppLogic.debugImage(bufferedImage, "Debug");
    }

    public static void debugImage(BufferedImage bufferedImage, String string) {
        Composition composition = AppLogic.getActiveComp();
        BufferedImage bufferedImage2 = ImageUtils.copyImage(bufferedImage);
        PixelitorWindow.getInstance().addNewImage(bufferedImage2, null, string);
        if (composition != null) {
            AppLogic.setActiveImageComponent(composition.getIC(), true);
        }
    }

    public static void debugRaster(Raster raster) {
        DirectColorModel directColorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        Raster raster2 = raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), 0, 0, null);
        BufferedImage bufferedImage = new BufferedImage(directColorModel, (WritableRaster)raster2, true, null);
        AppLogic.debugImage(bufferedImage);
    }

    public static void debugRasterWithEmptySpace(Raster raster) {
        BufferedImage bufferedImage = new BufferedImage(raster.getMinX() + raster.getWidth(), raster.getMinY() + raster.getHeight(), 7);
        bufferedImage.setData(raster);
        AppLogic.debugImage(bufferedImage);
    }

    public static void setActiveImageComponent(ImageComponent imageComponent, boolean bl) {
        activeImageComponent = imageComponent;
        if (bl) {
            if (imageComponent == null) {
                throw new IllegalStateException("imageComponent is null");
            }
            InternalImageFrame internalImageFrame = activeImageComponent.getInternalFrame();
            PixelitorWindow.getInstance().activateInternalImageFrame(internalImageFrame);
            imageComponent.onActivation();
        }
    }
}

