/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import pixelitor.menus.ShowHideAllAction;
import pixelitor.tools.Tools;

public class GlobalKeyboardWatch {
    private static boolean spaceDown = false;
    private static boolean showHideAllForTab = true;
    private static JComponent alwaysVisibleComponent;

    private GlobalKeyboardWatch() {
    }

    public static void init() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                int n;
                int n2 = keyEvent.getID();
                if (n2 == 401) {
                    int n3 = keyEvent.getKeyCode();
                    if (showHideAllForTab && n3 == 9) {
                        ShowHideAllAction.INSTANCE.actionPerformed(null);
                    } else if (n3 == 32) {
                        Tools.getCurrentTool().spacePressed();
                        spaceDown = true;
                    }
                } else if (n2 == 402 && (n = keyEvent.getKeyCode()) == 32) {
                    Tools.getCurrentTool().spaceReleased();
                    spaceDown = false;
                }
                return false;
            }
        });
    }

    public static boolean isSpaceDown() {
        return spaceDown;
    }

    public static void setShowHideAllForTab(boolean bl) {
        showHideAllForTab = bl;
    }

    public static void setAlwaysVisibleComponent(JComponent jComponent) {
        alwaysVisibleComponent = jComponent;
    }

    public static void addKeyboardShortCut(char c, boolean bl, String string, Action action) {
        InputMap inputMap = alwaysVisibleComponent.getInputMap(2);
        if (bl) {
            char c2 = Character.toLowerCase(c);
            char c3 = Character.toUpperCase(c);
            inputMap.put(KeyStroke.getKeyStroke(c2), string);
            inputMap.put(KeyStroke.getKeyStroke(c3), string);
        } else {
            inputMap.put(KeyStroke.getKeyStroke(c), string);
        }
        alwaysVisibleComponent.getActionMap().put(string, action);
    }

    public static void addKeyboardShortCut(KeyStroke keyStroke, String string, Action action) {
        InputMap inputMap = alwaysVisibleComponent.getInputMap(2);
        inputMap.put(keyStroke, string);
        alwaysVisibleComponent.getActionMap().put(string, action);
    }

    public static void registerBrushSizeActions() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tools.increaseActiveBrushSize();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tools.decreaseActiveBrushSize();
            }
        };
        GlobalKeyboardWatch.addKeyboardShortCut(']', false, "increment", abstractAction);
        GlobalKeyboardWatch.addKeyboardShortCut('[', false, "decrement", abstractAction2);
    }
}

