/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.dnd.DropTarget;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import pixelitor.AppLogic;
import pixelitor.Build;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.GlobalKeyboardWatch;
import pixelitor.ImageComponent;
import pixelitor.InternalImageFrame;
import pixelitor.io.DropListener;
import pixelitor.layers.LayersContainer;
import pixelitor.menus.MenuBar;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.tools.ToolSettingsPanelContainer;
import pixelitor.tools.Tools;
import pixelitor.tools.ToolsPanel;
import pixelitor.utils.AppPreferences;
import pixelitor.utils.HistogramsPanel;

public final class PixelitorWindow
extends JFrame {
    private static volatile PixelitorWindow singleInstance;
    private JDesktopPane desktopPane;
    private JLabel statusBar;
    private HistogramsPanel histogramsPanel;
    private Box verticalBoxEast;
    private Box verticalBoxWest;
    private ToolsPanel toolsPanel;
    private static final int CASCADE_HORIZONTAL_SHIFT = 15;
    private static final int CASCADE_VERTICAL_SHIFT = 25;

    private PixelitorWindow() throws HeadlessException {
        super(Build.getPixelitorWindowFixTitle());
        URL uRL;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AppLogic.exitApp();
            }
        });
        MenuBar menuBar = new MenuBar(this);
        this.setJMenuBar(menuBar);
        this.desktopPane = new JDesktopPane();
        GlobalKeyboardWatch.setAlwaysVisibleComponent(this.desktopPane);
        GlobalKeyboardWatch.registerBrushSizeActions();
        new DropTarget(this.desktopPane, new DropListener());
        this.desktopPane.setBackground(Color.GRAY);
        this.add((Component)this.desktopPane, "Center");
        this.verticalBoxEast = Box.createVerticalBox();
        this.histogramsPanel = HistogramsPanel.INSTANCE;
        AppLogic.addImageChangeListener(this.histogramsPanel);
        if (AppPreferences.WorkSpace.getHistogramsVisibility()) {
            this.verticalBoxEast.add(this.histogramsPanel);
        }
        if (AppPreferences.WorkSpace.getLayersVisibility()) {
            this.verticalBoxEast.add(LayersContainer.INSTANCE);
        }
        this.add((Component)this.verticalBoxEast, "East");
        this.verticalBoxWest = Box.createVerticalBox();
        this.toolsPanel = new ToolsPanel();
        if (AppPreferences.WorkSpace.getToolsVisibility()) {
            this.verticalBoxWest.add(this.toolsPanel);
            this.verticalBoxWest.add(FgBgColorSelector.INSTANCE);
            this.add((Component)ToolSettingsPanelContainer.INSTANCE, "North");
        }
        this.add((Component)this.verticalBoxWest, "West");
        this.statusBar = new JLabel("Pixelitor started");
        this.statusBar.setBorder(BorderFactory.createEtchedBorder());
        if (AppPreferences.WorkSpace.getStatusBarVisibility()) {
            this.add((Component)this.statusBar, "South");
        }
        if ((uRL = this.getClass().getResource("/images/pixelitor_icon.png")) != null) {
            this.setIconImage(new ImageIcon(uRL).getImage());
        } else {
            JOptionPane.showMessageDialog(this, "icon imgURL is null", "Error", 0);
        }
        GlobalKeyboardWatch.init();
        AppPreferences.loadFramePosition(this);
        this.setVisible(true);
    }

    public void activateInternalImageFrame(InternalImageFrame internalImageFrame) {
        if (internalImageFrame == null) {
            throw new IllegalArgumentException("frame is null");
        }
        this.desktopPane.getDesktopManager().activateFrame(internalImageFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PixelitorWindow getInstance() {
        if (singleInstance != null) return singleInstance;
        Class<PixelitorWindow> clazz = PixelitorWindow.class;
        synchronized (PixelitorWindow.class) {
            if (singleInstance != null) return singleInstance;
            singleInstance = new PixelitorWindow();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleInstance;
        }
    }

    public void addDeserializedComposition(Composition composition, File file) {
        AppLogic.activeImageComponent = new ImageComponent(file, composition);
        composition.restoreAfterDeserialization();
        try {
            this.addNewImageComponent();
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
    }

    public void addNewImage(BufferedImage bufferedImage, File file, String string) {
        AppLogic.activeImageComponent = new ImageComponent(file, string, bufferedImage);
        AppLogic.activeImageComponent.addBaseLayer(bufferedImage);
        AppLogic.activeImageComponent.setCursor(Tools.getCurrentTool().getCursor());
        try {
            this.addNewImageComponent();
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
    }

    public void cascadeWindows() {
        List<ImageComponent> list = AppLogic.getImageComponents();
        int n = 0;
        int n2 = 0;
        for (ImageComponent imageComponent : list) {
            InternalImageFrame internalImageFrame = imageComponent.getInternalFrame();
            internalImageFrame.setLocation(n, n2);
            internalImageFrame.setToNaturalSize(n, n2);
            try {
                internalImageFrame.setIcon(false);
                internalImageFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            n2 += 25;
            int n3 = this.desktopPane.getWidth() - 15;
            int n4 = this.desktopPane.getHeight() - 25;
            if ((n += 15) > n3) {
                n = 0;
            }
            if (n2 <= n4) continue;
            n2 = 0;
        }
    }

    public void tileWindows() {
        List<ImageComponent> list = AppLogic.getImageComponents();
        int n = list.size();
        int n2 = (int)Math.sqrt(n);
        int n3 = n / n2;
        int n4 = n % n2;
        int n5 = this.desktopPane.getWidth() / n3;
        int n6 = this.desktopPane.getHeight() / n2;
        int n7 = 0;
        int n8 = 0;
        for (ImageComponent imageComponent : list) {
            InternalImageFrame internalImageFrame = imageComponent.getInternalFrame();
            try {
                internalImageFrame.setIcon(false);
                internalImageFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            internalImageFrame.reshape(n8 * n5, n7 * n6, n5, n6);
            if (++n7 != n2) continue;
            n7 = 0;
            if (++n8 != n3 - n4) continue;
            n6 = this.desktopPane.getHeight() / ++n2;
        }
    }

    private void addNewImageComponent() {
        int n = AppLogic.getNrOfOpenImages();
        AppLogic.addImageComponent(AppLogic.activeImageComponent);
        int n2 = 15 * n;
        int n3 = 25 * n;
        int n4 = this.desktopPane.getWidth() - 15;
        int n5 = this.desktopPane.getHeight() - 25;
        InternalImageFrame internalImageFrame = new InternalImageFrame(AppLogic.activeImageComponent, n2 %= n4, n3 %= n5);
        internalImageFrame.setLocation(n2, n3);
        AppLogic.activeImageComponent.setInternalFrame(internalImageFrame);
        this.desktopPane.add(internalImageFrame);
        try {
            internalImageFrame.setSelected(true);
            this.desktopPane.getDesktopManager().activateFrame(internalImageFrame);
            AppLogic.newImageOpened();
        }
        catch (PropertyVetoException propertyVetoException) {
            ExceptionHandler.showExceptionDialog(propertyVetoException);
        }
    }

    public void setStatusBarMessage(String string) {
        this.statusBar.setText(string);
    }

    public boolean isStatusBarShown() {
        return this.statusBar.getParent() != null;
    }

    public void setStatusBarVisibility(boolean bl, boolean bl2) {
        if (bl) {
            this.add((Component)this.statusBar, "South");
        } else {
            this.remove(this.statusBar);
        }
        if (bl2) {
            ((JComponent)this.getContentPane()).revalidate();
        }
    }

    public void setHistogramsVisibility(boolean bl, boolean bl2) {
        if (bl) {
            this.verticalBoxEast.add(this.histogramsPanel);
            Composition composition = AppLogic.getActiveComp();
            if (composition != null) {
                this.histogramsPanel.updateFromCompIfShown(composition);
            }
        } else {
            this.verticalBoxEast.remove(this.histogramsPanel);
        }
        if (bl2) {
            this.verticalBoxEast.revalidate();
        }
    }

    public boolean areHistogramsShown() {
        return this.histogramsPanel.areHistogramsShown();
    }

    public void setLayersVisibility(boolean bl, boolean bl2) {
        if (bl) {
            this.verticalBoxEast.add(LayersContainer.INSTANCE);
        } else {
            this.verticalBoxEast.remove(LayersContainer.INSTANCE);
        }
        if (bl2) {
            this.verticalBoxEast.revalidate();
        }
    }

    public void setToolsVisibility(boolean bl, boolean bl2) {
        if (bl) {
            this.verticalBoxWest.add(this.toolsPanel);
            this.verticalBoxWest.add(FgBgColorSelector.INSTANCE);
            this.add((Component)ToolSettingsPanelContainer.INSTANCE, "North");
        } else {
            this.verticalBoxWest.remove(this.toolsPanel);
            this.verticalBoxWest.remove(FgBgColorSelector.INSTANCE);
            this.remove(ToolSettingsPanelContainer.INSTANCE);
        }
        if (bl2) {
            ((JComponent)this.getContentPane()).revalidate();
        }
    }

    public boolean areToolsShown() {
        return this.toolsPanel.getParent() != null;
    }

    public Dimension getDesktopSize() {
        return this.desktopPane.getSize();
    }

    public void iconify() {
        int n = this.getExtendedState();
        this.setExtendedState(n |= 1);
    }

    public void deiconify() {
        int n = this.getExtendedState();
        this.setExtendedState(n &= 0xFFFFFFFE);
    }
}

