/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.lookup.LuminanceLookup;
import pixelitor.utils.ImageUtils;

public class Colorize
extends FilterWithParametrizedGUI {
    private RangeParam adjustBrightnessParam = new RangeParam("Adjust Brightness", -100, 100, 0);
    private ColorParam colorParam = new ColorParam("Color:", new Color(255, 207, 119), false, false);

    public Colorize() {
        super("Colorize");
        this.paramSet = new ParamSet(this.colorParam, this.adjustBrightnessParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        float f = this.adjustBrightnessParam.getValueAsPercentage();
        Color color = this.colorParam.getColor();
        return Colorize.colorize(bufferedImage, bufferedImage2, color, f);
    }

    public static BufferedImage colorize(BufferedImage bufferedImage, BufferedImage bufferedImage2, Color color, float f) {
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int[] nArray3 = new int[256];
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray3[i] = i * n / 255;
            nArray4[i] = i * n2 / 255;
            nArray5[i] = i * n3 / 255;
        }
        for (int n4 : nArray) {
            int n5 = n4 & 0xFF000000;
            int n6 = LuminanceLookup.getLuminosity(n4);
            if (f > 0.0f) {
                n6 = (int)((float)n6 * (1.0f - f));
                n6 = (int)((float)n6 + (255.0f - (1.0f - f) * 255.0f));
            } else if (f < 0.0f) {
                n6 = (int)((float)n6 * (f + 1.0f));
            }
            int n7 = nArray3[n6];
            int n8 = nArray4[n6];
            int n9 = nArray5[n6];
            nArray2[var13_13] = n5 | n7 << 16 | n8 << 8 | n9;
        }
        return bufferedImage2;
    }
}

