/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import pixelitor.filters.Brick;
import pixelitor.filters.Fade;
import pixelitor.filters.Filter;
import pixelitor.filters.RGBPixelOp;
import pixelitor.utils.ImageUtils;

public class FilterUtils {
    private static List<Filter> allFilters = new ArrayList<Filter>();
    private static Filter lastExecutedFilter = null;

    private FilterUtils() {
    }

    public static Filter[] getAllFiltersSorted() {
        Object[] objectArray = allFilters.toArray(new Filter[allFilters.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static Filter getRandomFilter() {
        return allFilters.get((int)(Math.random() * (double)allFilters.size()));
    }

    public static Filter[] getAllFiltersShuffled() {
        Filter[] filterArray = allFilters.toArray(new Filter[allFilters.size()]);
        Collections.shuffle(Arrays.asList(filterArray));
        return filterArray;
    }

    public static void setLastExecutedFilter(Filter filter) {
        if (filter instanceof Fade) {
            return;
        }
        lastExecutedFilter = filter;
    }

    public static Filter getLastExecutedFilter() {
        return lastExecutedFilter;
    }

    public static BufferedImage runRGBPixelOp(RGBPixelOp rGBPixelOp, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = n >>> 24 & 0xFF;
            int n3 = n >>> 16 & 0xFF;
            int n4 = n >>> 8 & 0xFF;
            int n5 = n & 0xFF;
            nArray2[i] = rGBPixelOp.changeRGB(n2, n3, n4, n5);
        }
        return bufferedImage2;
    }

    public static BufferedImage getDefaultImage(BufferedImage bufferedImage) {
        return bufferedImage;
    }

    public static void addFilter(Filter filter) {
        if (!(filter instanceof Brick)) {
            allFilters.add(filter);
        }
    }
}

