/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.comp;

import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.filters.comp.CompOperation;
import pixelitor.history.OneLayerUndoableEdit;
import pixelitor.layers.ContentLayer;
import pixelitor.layers.Layer;

public class Rotate
extends CompOperation {
    private int angleDegree;
    private int newCanvasWidth;
    private int newCanvasHeight;

    public Rotate(int n, String string) {
        super(string);
        this.angleDegree = n;
    }

    @Override
    public void transform(Composition composition) {
        OneLayerUndoableEdit.createAndAddToHistory(composition, "Rotate", true, false);
        int n = composition.getNrLayers();
        int n2 = composition.getCanvasWidth();
        int n3 = composition.getCanvasHeight();
        for (int i = 0; i < n; ++i) {
            Layer layer = composition.getLayer(i);
            if (!(layer instanceof ContentLayer)) continue;
            ContentLayer contentLayer = (ContentLayer)layer;
            contentLayer.rotate(this.angleDegree);
        }
        if (!composition.hasSelection()) {
            this.rotateCanvas(n2, n3);
            composition.updateCanvasSize(this.newCanvasWidth, this.newCanvasHeight);
        }
        composition.setDirty(true);
        composition.imageChanged(true, false);
        AppLogic.activeCompositionDimensionsChanged(composition);
    }

    private void rotateCanvas(int n, int n2) {
        if (this.angleDegree == 90 || this.angleDegree == 270) {
            this.newCanvasWidth = n2;
            this.newCanvasHeight = n;
        } else {
            this.newCanvasWidth = n;
            this.newCanvasHeight = n2;
        }
    }
}

