/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import pixelitor.AppLogic;
import pixelitor.filters.gui.ImagePositionPanel;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.utils.ImageUtils;

public class ImagePositionSelector
extends JComponent
implements MouseMotionListener,
MouseListener {
    private ImagePositionPanel imagePositionPanel;
    private ImagePositionParam model;
    private BufferedImage thumb;
    private static final int CONTROL_SIZE = 5;

    public ImagePositionSelector(ImagePositionPanel imagePositionPanel, ImagePositionParam imagePositionParam, int n) {
        this.imagePositionPanel = imagePositionPanel;
        this.model = imagePositionParam;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        BufferedImage bufferedImage = AppLogic.getActiveComp().getActiveImageLayer().getImageForFilterDialogs();
        this.thumb = ImageUtils.createThumbnail(bufferedImage, n);
        this.setPreferredSize(new Dimension(this.thumb.getWidth(), this.thumb.getHeight()));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Line2D.Float float_;
        Line2D.Float float_2;
        int n = this.thumb.getWidth();
        int n2 = this.thumb.getHeight();
        graphics.drawImage(this.thumb, 0, 0, null);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n3 = (int)(this.model.getRelativeX() * (float)n);
        int n4 = (int)(this.model.getRelativeY() * (float)n2);
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n3 + 1, 0, n3 + 1, n2 - 1);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n2 - 1);
        if (n4 <= n2) {
            float_2 = new Line2D.Float(0.0f, n4 - 1, n, n4 - 1);
            float_ = new Line2D.Float(0.0f, n4 + 1, n, n4 + 1);
            graphics2D.draw(float_2);
            graphics2D.draw(float_);
        }
        graphics.setColor(Color.WHITE);
        float_2 = new Line2D.Float(n3, 0.0f, n3, n2);
        graphics2D.draw(float_2);
        if (n4 <= n2) {
            float_ = new Line2D.Float(0.0f, n4, n, n4);
            graphics2D.draw(float_);
        }
        graphics.setColor(Color.BLACK);
        graphics2D.draw(new Rectangle2D.Float(n3 - 5, n4 - 5, 10.0f, 10.0f));
        graphics.setColor(Color.WHITE);
        graphics2D.fill(new Rectangle2D.Float(n3 - 5 + 1, n4 - 5 + 1, 9.0f, 9.0f));
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveControl(mouseEvent);
    }

    private void moveControl(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        float f = (float)n / (float)this.thumb.getWidth();
        float f2 = (float)n2 / (float)this.thumb.getHeight();
        this.model.setRelativeX(f);
        this.model.setRelativeY(f2);
        this.imagePositionPanel.updateSlidersFromModel();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.moveControl(mouseEvent);
        ParamAdjustmentListener paramAdjustmentListener = this.model.getAdjustingListener();
        if (paramAdjustmentListener != null) {
            paramAdjustmentListener.paramAdjusted();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

