/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.AdjustPanel;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.gui.ParamSet;
import pixelitor.utils.GridBagHelper;

public class ParametrizedAdjustPanel
extends AdjustPanel
implements ParamAdjustmentListener {
    private static boolean resetParams = true;

    public ParametrizedAdjustPanel(FilterWithParametrizedGUI filterWithParametrizedGUI) {
        this(filterWithParametrizedGUI, null);
    }

    public ParametrizedAdjustPanel(FilterWithParametrizedGUI filterWithParametrizedGUI, Object object) {
        super(filterWithParametrizedGUI);
        ParamSet paramSet = filterWithParametrizedGUI.getParams();
        if (resetParams) {
            paramSet.reset();
        }
        paramSet.adjustmentListener(this);
        this.setupGUI(paramSet, object);
        this.paramAdjusted();
    }

    protected void setupGUI(ParamSet paramSet, Object object) {
        ParametrizedAdjustPanel.setupControlsInColumn(this, paramSet);
    }

    public static void setupControlsInColumn(JPanel jPanel, ParamSet paramSet) {
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        Container container = null;
        for (GUIParam gUIParam : paramSet) {
            JComponent jComponent = gUIParam.createGUI();
            if (gUIParam instanceof ActionParam) {
                if (container == null) {
                    container = new JPanel(new FlowLayout(1));
                    GridBagHelper.addOnlyControlToRow(jPanel, container, n);
                }
                container.add(jComponent);
            } else {
                int n2 = gUIParam.getNrOfGridBagCols();
                if (n2 == 1) {
                    GridBagHelper.addOnlyControlToRow(jPanel, jComponent, n);
                } else if (n2 == 2) {
                    GridBagHelper.addLabel((Container)jPanel, gUIParam.getName() + ':', 0, n);
                    GridBagHelper.addLastControl(jPanel, jComponent);
                }
            }
            ++n;
        }
    }

    @Override
    public void paramAdjusted() {
        super.executeFilterPreview();
    }

    public static void setResetParams(boolean bl) {
        resetParams = bl;
    }
}

