/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.impl;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.image.BufferedImage;

public class BrickBlockFilter
extends AbstractBufferedImageOp {
    private int horizontalBlockSize = 10;
    private int verticalBlockSize = 10;

    public void setHorizontalBlockSize(int n) {
        this.horizontalBlockSize = n;
    }

    public void setVerticalBlockSize(int n) {
        this.verticalBlockSize = n;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int[] nArray = new int[this.horizontalBlockSize * this.verticalBlockSize];
        int[] nArray2 = new int[this.horizontalBlockSize * this.verticalBlockSize / 2];
        int n3 = 0;
        for (int i = 0; i < n2; i += this.verticalBlockSize) {
            int n4 = 0;
            if (++n3 % 2 == 0) {
                n4 = this.horizontalBlockSize / 2;
                this.replaceWithAverage(bufferedImage, bufferedImage2, n, n2, nArray2, i, 0, this.horizontalBlockSize / 2, this.verticalBlockSize);
            }
            for (int j = n4; j < n; j += this.horizontalBlockSize) {
                this.replaceWithAverage(bufferedImage, bufferedImage2, n, n2, nArray, i, j, this.horizontalBlockSize, this.verticalBlockSize);
            }
        }
        return bufferedImage2;
    }

    private void replaceWithAverage(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, int[] nArray, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10 = Math.min(n5, n - n4);
        int n11 = Math.min(n6, n2 - n3);
        int n12 = n10 * n11;
        this.getRGB(bufferedImage, n4, n3, n10, n11, nArray);
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        for (n9 = 0; n9 < n11; ++n9) {
            for (n8 = 0; n8 < n10; ++n8) {
                n7 = nArray[n16];
                n13 += n7 >> 16 & 0xFF;
                n14 += n7 >> 8 & 0xFF;
                n15 += n7 & 0xFF;
                ++n16;
            }
        }
        n7 = n13 / n12 << 16 | n14 / n12 << 8 | n15 / n12;
        n16 = 0;
        for (n9 = 0; n9 < n11; ++n9) {
            for (n8 = 0; n8 < n10; ++n8) {
                nArray[n16] = nArray[n16] & 0xFF000000 | n7;
                ++n16;
            }
        }
        this.setRGB(bufferedImage2, n4, n3, n10, n11, nArray);
    }
}

