/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.DoGFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.Invert;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHDifferenceOfGaussians
extends FilterWithParametrizedGUI {
    private RangeParam radius1Param = new RangeParam("Radius 1", 0, 10, 0);
    private RangeParam radius2Param = new RangeParam("Radius 2", 0, 10, 4);
    private BooleanParam normalize = new BooleanParam("Maximize Contrast", true);
    private BooleanParam invert = new BooleanParam("Invert", false);
    private DoGFilter filter;

    public JHDifferenceOfGaussians() {
        super("Difference of Gaussians");
        this.paramSet = new ParamSet(this.radius1Param, this.radius2Param, this.normalize, this.invert);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new DoGFilter();
        }
        int n = this.radius1Param.getValue();
        int n2 = this.radius2Param.getValue();
        this.filter.setRadius1(n);
        this.filter.setRadius2(n2);
        this.filter.setNormalize(this.normalize.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        if (this.invert.getValue()) {
            Invert.invertImage(bufferedImage2, bufferedImage2);
        }
        return bufferedImage2;
    }
}

