/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.WaterFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHWaterRipple
extends FilterWithParametrizedGUI {
    private ImagePositionParam center = new ImagePositionParam("Center");
    private RangeParam radius = new RangeParam("Radius", 1, 999, 200);
    private RangeParam wavelength = new RangeParam("Wavelength", 1, 250, 25);
    private RangeParam amplitude = new RangeParam("Amplitude", 1, 100, 50);
    private RangeParam phase = new RangeParam("Phase (Time)", 0, 360, 0);
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private WaterFilter filter;

    public JHWaterRipple() {
        super("Water Ripple");
        this.paramSet = new ParamSet(this.center, this.radius, this.wavelength, this.amplitude, this.phase, this.edgeAction, this.interpolation);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new WaterFilter();
        }
        this.filter.setCentreX(this.center.getRelativeX());
        this.filter.setCentreY(this.center.getRelativeY());
        this.filter.setRadius(this.radius.getValue());
        this.filter.setWavelength(this.wavelength.getValue());
        this.filter.setAmplitude(this.amplitude.getValueAsPercentage());
        this.filter.setPhase(this.phase.getValueInRadians());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

