/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.WoodFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.GradientParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.gui.ReseedNoiseAction;

public class JHWood
extends FilterWithParametrizedGUI {
    private RangeParam ringsParam = new RangeParam("Rings", 1, 100, 50);
    private RangeParam scaleParam = new RangeParam("Zoom (%)", 1, 500, 100);
    private RangeParam stretchParam = new RangeParam("Stretch", 1, 50, 10);
    private AngleParam angleParam = new AngleParam("Angle", 0.0);
    private RangeParam turbulenceParam = new RangeParam("Turbulence", 0, 100, 0);
    private RangeParam fibresParam = new RangeParam("Fibres", 0, 100, 10);
    private RangeParam gainParam = new RangeParam("Gain", 0, 100, 80);
    private GradientParam gradientParam = new GradientParam("Colors", new Color(229, 196, 148), new Color(152, 123, 81));
    private WoodFilter filter;

    public JHWood() {
        super("Wood");
        this.paramSet = new ParamSet(this.angleParam, this.scaleParam, this.stretchParam, this.gradientParam, this.ringsParam, this.turbulenceParam, this.fibresParam, this.gainParam, new ReseedNoiseAction());
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new WoodFilter();
        }
        double d = this.angleParam.getValueInRadians() + 1.5707963267948966;
        this.filter.setAngle((float)d);
        this.filter.setScale(this.scaleParam.getValue());
        this.filter.setStretch(this.stretchParam.getValue());
        this.filter.setRings(this.ringsParam.getValueAsPercentage());
        this.filter.setTurbulence(this.turbulenceParam.getValueAsPercentage());
        this.filter.setFibres(this.fibresParam.getValueAsPercentage());
        this.filter.setGain(this.gainParam.getValueAsPercentage());
        this.filter.setColormap(this.gradientParam.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

