/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.levels.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Box;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.levels.GrayScaleLookup;
import pixelitor.filters.levels.gui.GrayScaleAdjustmentChangeListener;
import pixelitor.utils.CardPanelWithCombo;
import pixelitor.utils.SliderSpinner;

public class OneChannelLevelsPanel
extends CardPanelWithCombo.Card
implements ParamAdjustmentListener {
    private Collection<SliderSpinner> sliders = new ArrayList<SliderSpinner>();
    private Box box = Box.createVerticalBox();
    private GrayScaleLookup adjustment = GrayScaleLookup.getDefaultAdjustment();
    private static final int BLACK_DEFAULT = 0;
    private static final int WHITE_DEFAULT = 255;
    private static final Color DARK_CYAN = new Color(0, 128, 128);
    private static final Color LIGHT_PINK = new Color(255, 128, 128);
    private static final Color DARK_PURPLE = new Color(128, 0, 128);
    private static final Color LIGHT_GREEN = new Color(128, 255, 128);
    private static final Color DARK_YELLOW_GREEN = new Color(128, 128, 0);
    private static final Color LIGHT_BLUE = new Color(128, 128, 255);
    private static final Color DARK_BLUE = new Color(0, 0, 128);
    private static final Color LIGHT_YELLOW = new Color(255, 255, 128);
    private static final Color DARK_GREEN = new Color(0, 128, 0);
    private static final Color LIGHT_PURPLE = new Color(255, 128, 255);
    private static final Color DARK_RED = new Color(128, 0, 0);
    private static final Color LIGHT_CYAN = new Color(128, 255, 128);
    private SliderSpinner inputBlackSlider;
    private SliderSpinner inputWhiteSlider;
    private SliderSpinner outputBlackSlider;
    private SliderSpinner outputWhiteSlider;
    private final GrayScaleAdjustmentChangeListener grayScaleAdjustmentChangeListener;

    public OneChannelLevelsPanel(Type type, GrayScaleAdjustmentChangeListener grayScaleAdjustmentChangeListener) {
        super(type.getName());
        this.grayScaleAdjustmentChangeListener = grayScaleAdjustmentChangeListener;
        this.add(this.box);
        RangeParam rangeParam = new RangeParam("Input Dark", 0, 255, 0);
        rangeParam.setAdjustmentListener(this);
        this.inputBlackSlider = new SliderSpinner(Color.GRAY, type.getBackColor(), rangeParam);
        RangeParam rangeParam2 = new RangeParam("Input Light", 0, 255, 255);
        rangeParam2.setAdjustmentListener(this);
        this.inputWhiteSlider = new SliderSpinner(type.getWhiteColor(), Color.GRAY, rangeParam2);
        RangeParam rangeParam3 = new RangeParam("Output Dark", 0, 255, 0);
        rangeParam3.setAdjustmentListener(this);
        this.outputBlackSlider = new SliderSpinner(Color.GRAY, type.getWhiteColor(), rangeParam3);
        RangeParam rangeParam4 = new RangeParam("Output Light", 0, 255, 255);
        rangeParam4.setAdjustmentListener(this);
        this.outputWhiteSlider = new SliderSpinner(type.getBackColor(), Color.GRAY, rangeParam4);
        this.addSliderSpinner(this.inputBlackSlider);
        this.addSliderSpinner(this.inputWhiteSlider);
        this.addSliderSpinner(this.outputBlackSlider);
        this.addSliderSpinner(this.outputWhiteSlider);
    }

    public void resetToDefaultSettings() {
        for (SliderSpinner sliderSpinner : this.sliders) {
            sliderSpinner.resetToDefaultSettings();
        }
        this.updateAdjustment();
    }

    private void addSliderSpinner(SliderSpinner sliderSpinner) {
        this.box.add(sliderSpinner);
        this.sliders.add(sliderSpinner);
    }

    public GrayScaleLookup getAdjustment() {
        return this.adjustment;
    }

    @Override
    public void paramAdjusted() {
        this.updateAdjustment();
        this.grayScaleAdjustmentChangeListener.grayScaleAdjustmentHasChanged();
    }

    private void updateAdjustment() {
        int n = this.inputBlackSlider.getCurrentValue();
        int n2 = this.inputWhiteSlider.getCurrentValue();
        int n3 = this.outputBlackSlider.getCurrentValue();
        int n4 = this.outputWhiteSlider.getCurrentValue();
        this.adjustment = new GrayScaleLookup(n, n2, n3, n4);
    }

    static enum Type {
        RGB{

            @Override
            public String getName() {
                return "Red, Green, Blue";
            }

            @Override
            Color getBackColor() {
                return Color.BLACK;
            }

            @Override
            Color getWhiteColor() {
                return Color.WHITE;
            }
        }
        ,
        R{

            @Override
            public String getName() {
                return "Red";
            }

            @Override
            Color getBackColor() {
                return DARK_CYAN;
            }

            @Override
            Color getWhiteColor() {
                return LIGHT_PINK;
            }
        }
        ,
        G{

            @Override
            public String getName() {
                return "Green";
            }

            @Override
            Color getBackColor() {
                return DARK_PURPLE;
            }

            @Override
            Color getWhiteColor() {
                return LIGHT_GREEN;
            }
        }
        ,
        B{

            @Override
            public String getName() {
                return "Blue";
            }

            @Override
            Color getBackColor() {
                return DARK_YELLOW_GREEN;
            }

            @Override
            Color getWhiteColor() {
                return LIGHT_BLUE;
            }
        }
        ,
        RG{

            @Override
            public String getName() {
                return "Red, Green";
            }

            @Override
            Color getBackColor() {
                return DARK_BLUE;
            }

            @Override
            Color getWhiteColor() {
                return LIGHT_YELLOW;
            }
        }
        ,
        RB{

            @Override
            public String getName() {
                return "Red, Blue";
            }

            @Override
            Color getBackColor() {
                return DARK_GREEN;
            }

            @Override
            Color getWhiteColor() {
                return LIGHT_PURPLE;
            }
        }
        ,
        GB{

            @Override
            public String getName() {
                return "Green, Blue";
            }

            @Override
            Color getBackColor() {
                return DARK_RED;
            }

            @Override
            Color getWhiteColor() {
                return LIGHT_CYAN;
            }
        };


        abstract String getName();

        abstract Color getBackColor();

        abstract Color getWhiteColor();
    }
}

