/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.painters;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jdesktop.swingx.painter.effects.AbstractAreaEffect;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import org.jdesktop.swingx.painter.effects.GlowPathEffect;
import org.jdesktop.swingx.painter.effects.InnerGlowPathEffect;
import org.jdesktop.swingx.painter.effects.NeonBorderEffect;
import org.jdesktop.swingx.painter.effects.ShadowPathEffect;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.painters.DropShadowEffectConfigurator;
import pixelitor.filters.painters.EffectConfigurator;
import pixelitor.filters.painters.NeonBorderEffectConfigurator;
import pixelitor.utils.GUIUtils;

public class EffectsPanel
extends JPanel {
    private EffectConfigurator glowConfigurator;
    private EffectConfigurator innerGlowConfigurator;
    private NeonBorderEffectConfigurator neonBorderConfigurator;
    private DropShadowEffectConfigurator dropShadowConfigurator;
    private GlowPathEffect glowEffect;
    private InnerGlowPathEffect innerGlowEffect;
    private NeonBorderEffect neonBorderEffect;
    private ShadowPathEffect dropShadowEffect;
    private JTabbedPane tabs;

    public EffectsPanel(ParamAdjustmentListener paramAdjustmentListener) {
        this.setLayout(new BorderLayout());
        this.glowConfigurator = new EffectConfigurator("Glow", false, Color.WHITE, 10);
        this.innerGlowConfigurator = new EffectConfigurator("Inner Glow", false, Color.WHITE, 10);
        this.neonBorderConfigurator = new NeonBorderEffectConfigurator(false, Color.GREEN, Color.WHITE, 10);
        this.dropShadowConfigurator = new DropShadowEffectConfigurator(false, Color.BLACK, 10);
        if (paramAdjustmentListener != null) {
            this.glowConfigurator.setAdjustmentListener(paramAdjustmentListener);
            this.innerGlowConfigurator.setAdjustmentListener(paramAdjustmentListener);
            this.neonBorderConfigurator.setAdjustmentListener(paramAdjustmentListener);
            this.dropShadowConfigurator.setAdjustmentListener(paramAdjustmentListener);
        }
        this.tabs = new JTabbedPane();
        this.tabs.setTabPlacement(2);
        this.tabs.setTabLayoutPolicy(0);
        this.addTab("Glow               ", this.glowConfigurator);
        this.addTab("Inner Glow     ", this.innerGlowConfigurator);
        this.addTab("Neon Border ", this.neonBorderConfigurator);
        this.addTab("Drop Shadow", this.dropShadowConfigurator);
        this.tabs.setPreferredSize(new Dimension(530, 250));
        this.add((Component)this.tabs, "Center");
    }

    public void updateEffectsFromGUI() {
        if (this.glowConfigurator.isSelected()) {
            this.glowEffect = new GlowPathEffect();
            this.glowConfigurator.updateEffectColorAndBrush(this.glowEffect);
        } else {
            this.glowEffect = null;
        }
        if (this.innerGlowConfigurator.isSelected()) {
            this.innerGlowEffect = new InnerGlowPathEffect();
            this.innerGlowConfigurator.updateEffectColorAndBrush(this.innerGlowEffect);
        } else {
            this.innerGlowEffect = null;
        }
        if (this.neonBorderConfigurator.isSelected()) {
            Color color = this.neonBorderConfigurator.getColor();
            Color color2 = this.neonBorderConfigurator.getInnerColor();
            int n = this.neonBorderConfigurator.getBrushWidth();
            this.neonBorderEffect = new NeonBorderEffect(color, color2, n);
        } else {
            this.neonBorderEffect = null;
        }
        if (this.dropShadowConfigurator.isSelected()) {
            this.dropShadowEffect = new ShadowPathEffect();
            this.dropShadowConfigurator.updateEffectColorAndBrush(this.dropShadowEffect);
            this.dropShadowEffect.setOffset(this.dropShadowConfigurator.getOffset());
        } else {
            this.dropShadowEffect = null;
        }
    }

    private void addTab(String string, EffectConfigurator effectConfigurator) {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setModel(effectConfigurator.getEnabledModel());
        jPanel.add(jCheckBox);
        jPanel.add(new JLabel(string));
        jPanel.setOpaque(false);
        this.tabs.addTab(string, effectConfigurator);
        this.tabs.setTabComponentAt(this.tabs.getTabCount() - 1, jPanel);
    }

    public AreaEffect[] getEffectsAsArray() {
        ArrayList<AbstractAreaEffect> arrayList = new ArrayList<AbstractAreaEffect>(2);
        if (this.dropShadowEffect != null) {
            arrayList.add(this.dropShadowEffect);
        }
        if (this.glowEffect != null) {
            arrayList.add(this.glowEffect);
        }
        if (this.innerGlowEffect != null) {
            arrayList.add(this.innerGlowEffect);
        }
        if (this.neonBorderEffect != null) {
            arrayList.add(this.neonBorderEffect);
        }
        AreaEffect[] areaEffectArray = arrayList.toArray(new AreaEffect[arrayList.size()]);
        return areaEffectArray;
    }

    public int getMaxEffectThickness() {
        int n;
        int n2 = 0;
        if (this.glowEffect != null && (n = this.glowEffect.getEffectWidth()) > n2) {
            n2 = n;
        }
        if (this.neonBorderEffect != null && (n = this.neonBorderEffect.getEffectWidth()) > n2) {
            n2 = n;
        }
        if (this.dropShadowEffect != null) {
            int n3;
            Point2D point2D;
            double d = 2.0;
            int n4 = 3 + (int)((double)this.dropShadowEffect.getEffectWidth() * d);
            int n5 = n4 + (int)Math.abs((point2D = this.dropShadowEffect.getOffset()).getX() * d);
            if (n5 > n2) {
                n2 = n5;
            }
            if ((n3 = n4 + (int)Math.abs(point2D.getY() * d)) > n2) {
                n2 = n3;
            }
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        GUIUtils.testJComponent(new EffectsPanel(null));
    }
}

