/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.painters;

import com.bric.swing.ColorPicker;
import com.bric.swing.ColorSwatch;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import pixelitor.PixelitorWindow;
import pixelitor.filters.painters.EffectConfigurator;
import pixelitor.utils.GridBagHelper;

public class NeonBorderEffectConfigurator
extends EffectConfigurator {
    private Color innerColor;
    private ColorSwatch innerColorSwatch;

    NeonBorderEffectConfigurator(boolean bl, Color color, Color color2, int n) {
        super("Neon Border", bl, color, n);
        this.innerColor = color2;
        this.innerColorSwatch = new ColorSwatch(this.innerColor, 20);
        this.innerColorSwatch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Color color = ColorPicker.showDialog(PixelitorWindow.getInstance(), "Select Color", NeonBorderEffectConfigurator.this.innerColor, true);
                if (color != null) {
                    NeonBorderEffectConfigurator.this.innerColor = color;
                    NeonBorderEffectConfigurator.this.innerColorSwatch.setForeground(NeonBorderEffectConfigurator.this.innerColor);
                    NeonBorderEffectConfigurator.this.innerColorSwatch.paintImmediately(0, 0, 20, 20);
                    if (NeonBorderEffectConfigurator.this.adjustmentListener != null) {
                        NeonBorderEffectConfigurator.this.adjustmentListener.paramAdjusted();
                    }
                }
            }
        });
        GridBagHelper.addLabel((Container)this, "Inner Color:", 0, 3);
        GridBagHelper.addControlNoFill(this, this.innerColorSwatch);
    }

    public Color getInnerColor() {
        return this.innerColor;
    }
}

