/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEditSupport;
import pixelitor.AppLogic;
import pixelitor.Build;
import pixelitor.Composition;
import pixelitor.ConsistencyChecks;
import pixelitor.ExceptionHandler;
import pixelitor.history.FadeableEdit;
import pixelitor.history.PixelitorEdit;
import pixelitor.history.PixelitorUndoManager;
import pixelitor.selection.Selection;
import pixelitor.utils.AppPreferences;
import pixelitor.utils.test.DebugEventQueue;
import pixelitor.utils.test.HistoryEvent;

public final class History {
    private static UndoableEditSupport undoableEditSupport = new UndoableEditSupport();
    private static PixelitorUndoManager undoManager = new PixelitorUndoManager();
    private static int undoDepth = 0;

    private History() {
    }

    public static void postEdit(PixelitorEdit pixelitorEdit) {
        undoableEditSupport.postEdit(pixelitorEdit);
    }

    public static void addEdit(PixelitorEdit pixelitorEdit) {
        if (pixelitorEdit == null) {
            return;
        }
        if (pixelitorEdit.canUndo()) {
            undoManager.addEdit(pixelitorEdit);
        } else {
            undoManager.discardAllEdits();
        }
        undoDepth = 0;
        undoableEditSupport.postEdit(pixelitorEdit);
        if (Build.CURRENT != Build.FINAL) {
            ConsistencyChecks.checkAll();
            DebugEventQueue.post(new HistoryEvent(pixelitorEdit));
        }
    }

    public static String getUndoPresentationName() {
        return undoManager.getUndoPresentationName();
    }

    public static String getRedoPresentationName() {
        return undoManager.getRedoPresentationName();
    }

    public static void redo() {
        if (Build.CURRENT != Build.FINAL) {
            DebugEventQueue.post(HistoryEvent.createRedoEvent());
        }
        try {
            undoManager.redo();
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
        --undoDepth;
    }

    public static void undo() {
        if (Build.CURRENT != Build.FINAL) {
            DebugEventQueue.post(HistoryEvent.createUndoEvent());
        }
        try {
            ++undoDepth;
            undoManager.undo();
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
    }

    public static boolean canUndo() {
        return undoManager.canUndo();
    }

    public static boolean canRedo() {
        return undoManager.canRedo();
    }

    public static void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        undoableEditSupport.addUndoableEditListener(undoableEditListener);
    }

    public static void setUndoLevels(int n) {
        undoManager.setLimit(n);
    }

    public static int getUndoLevels() {
        return undoManager.getLimit();
    }

    public static boolean canRepeatOperation() {
        if (undoDepth > 0) {
            return false;
        }
        PixelitorEdit pixelitorEdit = undoManager.getLastEdit();
        if (pixelitorEdit != null) {
            return pixelitorEdit.canRepeat();
        }
        return false;
    }

    public static String getLastPresentationName() {
        PixelitorEdit pixelitorEdit = undoManager.getLastEdit();
        if (pixelitorEdit != null) {
            return pixelitorEdit.getPresentationName();
        }
        return "";
    }

    public static FadeableEdit getPreviousEditForFade(Composition composition) {
        if (undoDepth > 0) {
            return null;
        }
        PixelitorEdit pixelitorEdit = undoManager.getLastEdit();
        if (pixelitorEdit != null && pixelitorEdit instanceof FadeableEdit) {
            Composition composition2 = pixelitorEdit.getComp();
            if (composition != composition2) {
                return null;
            }
            return (FadeableEdit)pixelitorEdit;
        }
        return null;
    }

    public static boolean canFade() {
        Composition composition = AppLogic.getActiveComp();
        return History.getPreviousEditForFade(composition) != null;
    }

    public static void allImagesAreClosed() {
        undoDepth = 0;
        undoManager.discardAllEdits();
        undoableEditSupport.postEdit(null);
    }

    public static void showHistory() {
        undoManager.showHistory();
    }

    public static void dumpHistory() {
        History.showHistory();
        System.out.println("HISTORY DUMP undoDepth = " + undoDepth);
        Composition composition = AppLogic.getActiveComp();
        if (composition != null) {
            Selection selection = composition.getSelection();
            System.out.println("History.dumpHistory selection = " + selection);
        }
        undoManager.dumpHistory();
    }

    static {
        History.setUndoLevels(AppPreferences.loadUndoLevels());
    }
}

