/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import java.awt.image.BufferedImage;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.layers.ContentLayer;
import pixelitor.layers.ImageLayer;

public class TranslateEdit
extends PixelitorEdit {
    private BufferedImage backupImage;
    private ContentLayer layer;
    private int backupTranslationX = 0;
    private int backupTranslationY = 0;

    public TranslateEdit(ContentLayer contentLayer, BufferedImage bufferedImage, int n, int n2) {
        super(contentLayer.getComposition(), "Layer Movement");
        this.layer = contentLayer;
        this.backupImage = bufferedImage;
        this.backupTranslationX = n;
        this.backupTranslationY = n2;
        contentLayer.getComposition().setDirty(true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.swapTranslation();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.swapTranslation();
    }

    private void swapTranslation() {
        int n = this.layer.getTranslationX();
        int n2 = this.layer.getTranslationY();
        BufferedImage bufferedImage = null;
        if (this.backupImage != null) {
            ImageLayer imageLayer = (ImageLayer)this.layer;
            bufferedImage = imageLayer.getBufferedImage();
            imageLayer.setBufferedImage(this.backupImage, true);
        }
        this.layer.setTranslationX(this.backupTranslationX);
        this.layer.setTranslationY(this.backupTranslationY);
        this.backupTranslationX = n;
        this.backupTranslationY = n2;
        this.backupImage = bufferedImage;
        this.layer.getComposition().imageChanged(true, true);
        History.postEdit(this);
    }

    @Override
    public void die() {
        super.die();
        if (this.backupImage != null) {
            this.backupImage.flush();
            this.backupImage = null;
        }
        this.layer = null;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

