/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.io;

import java.io.File;
import java.io.FileFilter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileExtensionUtils {
    public static final String[] SUPPORTED_INPUT_FORMATS = new String[]{"jpg", "jpeg", "png", "gif", "bmp", "pxc"};
    public static final String[] SUPPORTED_OUTPUT_FORMATS = SUPPORTED_INPUT_FORMATS;
    private static javax.swing.filechooser.FileFilter jpegFilter = new FileNameExtensionFilter("JPEG files", "jpg", "jpeg");
    private static javax.swing.filechooser.FileFilter pngFilter = new FileNameExtensionFilter("PNG files", "png");
    private static javax.swing.filechooser.FileFilter bmpFilter = new FileNameExtensionFilter("BMP files", "bmp");
    private static javax.swing.filechooser.FileFilter gifFilter = new FileNameExtensionFilter("GIF files", "gif");
    private static javax.swing.filechooser.FileFilter pxcFilter = new FileNameExtensionFilter("PXC files", "pxc");

    private FileExtensionUtils() {
    }

    public static void addOpenFilters(JFileChooser jFileChooser) {
        jFileChooser.addChoosableFileFilter(pngFilter);
        jFileChooser.addChoosableFileFilter(bmpFilter);
        jFileChooser.addChoosableFileFilter(gifFilter);
        jFileChooser.addChoosableFileFilter(pxcFilter);
        jFileChooser.addChoosableFileFilter(jpegFilter);
    }

    public static void addSaveFilters(JFileChooser jFileChooser) {
        FileExtensionUtils.addOpenFilters(jFileChooser);
    }

    public static void setupJPegSaveFilter(JFileChooser jFileChooser) {
        jFileChooser.removeChoosableFileFilter(pngFilter);
        jFileChooser.removeChoosableFileFilter(bmpFilter);
        jFileChooser.removeChoosableFileFilter(gifFilter);
        jFileChooser.removeChoosableFileFilter(pxcFilter);
        jFileChooser.setFileFilter(jpegFilter);
    }

    public static javax.swing.filechooser.FileFilter getFileFilterForExtension(String string) {
        if (string != null) {
            string = string.toLowerCase();
        }
        if ("jpg".equals(string)) {
            return jpegFilter;
        }
        if ("jpeg".equals(string)) {
            return jpegFilter;
        }
        if ("png".equals(string)) {
            return pngFilter;
        }
        if ("bmp".equals(string)) {
            return bmpFilter;
        }
        if ("gif".equals(string)) {
            return gifFilter;
        }
        if ("pxc".equals(string)) {
            return pxcFilter;
        }
        return jpegFilter;
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1, string.length());
    }

    public static String getFileNameWOExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static boolean isSupportedExtension(String string, String[] stringArray) {
        String string2 = FileExtensionUtils.getFileExtension(string);
        if (string2 == null) {
            return false;
        }
        string2 = string2.toLowerCase();
        for (String string3 : stringArray) {
            if (!string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public static File[] getAllSupportedFilesInDir(File file) {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileExtensionUtils.isSupportedExtension(file.getName(), SUPPORTED_INPUT_FORMATS);
            }
        };
        File[] fileArray = file.listFiles(fileFilter);
        return fileArray;
    }

    public static String replaceExtension(String string, String string2) {
        String string3 = FileExtensionUtils.getFileExtension(string);
        if (string3 == null) {
            return string + '.' + string2;
        }
        String string4 = FileExtensionUtils.getFileNameWOExtension(string);
        return string4 + '.' + string2;
    }
}

