/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.history.LayerBlendingEdit;
import pixelitor.history.LayerOpacityEdit;
import pixelitor.history.LayerRenameEdit;
import pixelitor.history.LayerVisibilityChangeEdit;
import pixelitor.layers.BlendingMode;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.LayerBlendingModePanel;
import pixelitor.layers.LayerButton;
import pixelitor.layers.LayerMask;
import pixelitor.utils.HistogramsPanel;

public abstract class Layer
implements Serializable {
    private static final long serialVersionUID = 2L;
    String name;
    private boolean visible = true;
    Composition comp;
    LayerMask layerMask;
    private transient LayerButton layerButton;
    float opacity = 1.0f;
    BlendingMode blendingMode = BlendingMode.NORMAL;

    Layer(Composition composition, String string) {
        this.comp = composition;
        this.name = string;
        this.opacity = 1.0f;
        this.layerButton = new LayerButton(this);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl, boolean bl2) {
        if (this.visible == bl) {
            return;
        }
        this.visible = bl;
        this.comp.imageChanged(true, true);
        this.comp.setDirty(true);
        this.layerButton.setOpenEye(bl);
        if (bl2) {
            LayerVisibilityChangeEdit layerVisibilityChangeEdit = new LayerVisibilityChangeEdit(this.comp, this, bl);
            History.addEdit(layerVisibilityChangeEdit);
        }
    }

    public LayerButton getLayerButton() {
        return this.layerButton;
    }

    String getDuplicateLayerName() {
        int n;
        String string = "copy";
        int n2 = string.length();
        int n3 = this.name.lastIndexOf(string);
        if (n3 == -1) {
            return this.name + ' ' + string;
        }
        if (n3 == this.name.length() - n2) {
            return this.name + " 2";
        }
        String string2 = this.name.substring(n3 + n2);
        try {
            n = Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return this.name + ' ' + string;
        }
        return this.name.substring(0, n3 + n2) + ' ' + ++n;
    }

    public abstract Layer duplicate();

    public float getOpacity() {
        return this.opacity;
    }

    public BlendingMode getBlendingMode() {
        return this.blendingMode;
    }

    private void updateAfterBMorOpacityChange() {
        this.comp.imageChanged(true, true);
        HistogramsPanel histogramsPanel = HistogramsPanel.INSTANCE;
        if (histogramsPanel.areHistogramsShown()) {
            histogramsPanel.updateFromCompIfShown(this.comp);
        }
    }

    public void setOpacity(float f, boolean bl, boolean bl2) {
        if (bl2) {
            LayerOpacityEdit layerOpacityEdit = new LayerOpacityEdit(this, this.opacity);
            History.addEdit(layerOpacityEdit);
        }
        if (f > 1.0f) {
            throw new IllegalArgumentException("newOpacity = " + f);
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("newOpacity = " + f);
        }
        this.opacity = f;
        if (bl) {
            LayerBlendingModePanel.INSTANCE.setOpacity(f);
        }
        this.updateAfterBMorOpacityChange();
    }

    public void setBlendingMode(BlendingMode blendingMode, boolean bl, boolean bl2) {
        if (bl2) {
            LayerBlendingEdit layerBlendingEdit = new LayerBlendingEdit(this, this.blendingMode);
            History.addEdit(layerBlendingEdit);
        }
        this.blendingMode = blendingMode;
        if (bl) {
            LayerBlendingModePanel.INSTANCE.setBlendingModeNotUI(blendingMode);
        }
        this.updateAfterBMorOpacityChange();
    }

    public void setName(String string, boolean bl) {
        String string2 = this.name;
        this.name = string;
        if (this.name.equals(string2)) {
            return;
        }
        this.layerButton.setName(string);
        if (bl) {
            LayerRenameEdit layerRenameEdit = new LayerRenameEdit(this, string2, this.name);
            History.addEdit(layerRenameEdit);
        }
    }

    public String getName() {
        return this.name;
    }

    public Composition getComposition() {
        return this.comp;
    }

    public abstract void mergeDownOn(ImageLayer var1);

    public void makeActive(boolean bl) {
        this.comp.setActiveLayer(this, bl);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.layerButton = new LayerButton(this);
    }

    boolean isActiveLayer() {
        return this.comp.isActiveLayer(this);
    }

    public boolean hasLayerMask() {
        return this.layerMask != null;
    }

    public void addTestLayerMask() {
        int n = this.comp.getCanvasWidth();
        int n2 = this.comp.getCanvasHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = Color.WHITE;
        Color color2 = Color.BLACK;
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n2, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        this.layerMask = new LayerMask(bufferedImage);
        this.comp.imageChanged(true, true);
    }

    public abstract BufferedImage paintLayer(Graphics2D var1, boolean var2, BufferedImage var3);

    public abstract void resize(int var1, int var2, boolean var3);

    public abstract void crop(Rectangle var1);

    public LayerMask getLayerMask() {
        return this.layerMask;
    }
}

