/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.menus;

import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.utils.ImageSwitchListener;

public class FadeMenuItem
extends JMenuItem
implements UndoableEditListener,
ImageSwitchListener {
    public FadeMenuItem(Action action) {
        super(action);
        History.addUndoableEditListener(this);
        AppLogic.addImageChangeListener(this);
        this.setEnabled(false);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        boolean bl = History.canFade();
        this.setEnabled(bl);
        this.getAction().putValue("Name", "Fade " + History.getLastPresentationName());
    }

    @Override
    public void noOpenImageAnymore() {
        this.setEnabled(false);
    }

    @Override
    public void newImageOpened() {
        this.setEnabled(false);
    }

    @Override
    public void activeCompositionHasChanged(Composition composition) {
        this.setEnabled(History.canFade());
    }
}

