/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;
import pixelitor.AppLogic;
import pixelitor.ImageComponent;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.Layers;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.tools.Tool;

public class ColorPickerTool
extends Tool {
    private JCheckBox sampleLayerOnly = new JCheckBox("Sample Active Layer Only");

    public ColorPickerTool() {
        super('i', "Color Picker", "color_picker_tool_icon.gif", "click to pick the foreground color, Alt-click to pick the background color", Cursor.getPredefinedCursor(1), false, true, false);
    }

    @Override
    void initSettingsPanel() {
        this.toolSettingsPanel.add(this.sampleLayerOnly);
    }

    @Override
    public void toolMousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
        this.sampleColor(mouseEvent, imageComponent, mouseEvent.isAltDown());
    }

    @Override
    public void toolMouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        this.sampleColor(mouseEvent, imageComponent, mouseEvent.isAltDown());
    }

    @Override
    public void toolMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
    }

    public void sampleColor(MouseEvent mouseEvent, ImageComponent imageComponent, boolean bl) {
        BufferedImage bufferedImage;
        double d = imageComponent.getViewScale();
        int n = (int)((double)mouseEvent.getX() / d);
        int n2 = (int)((double)mouseEvent.getY() / d);
        if (this.sampleLayerOnly.isSelected()) {
            if (!Layers.activeIsImageLayer()) {
                return;
            }
            bufferedImage = imageComponent.getComp().getActiveImageLayer().getBufferedImage();
            ImageLayer imageLayer = imageComponent.getComp().getActiveImageLayer();
            n -= imageLayer.getTranslationX();
            n2 -= imageLayer.getTranslationY();
        } else {
            bufferedImage = imageComponent.getComp().getCompositeImage();
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (n < n3 && n2 < n4 && n >= 0 && n2 >= 0) {
            int n5 = bufferedImage.getRGB(n, n2);
            ColorPickerTool.showColorInStatusBar(n, n2, n5);
            Color color = new Color(n5);
            if (bl) {
                FgBgColorSelector.INSTANCE.setBgColor(color);
            } else {
                FgBgColorSelector.INSTANCE.setFgColor(color);
            }
        }
    }

    private static void showColorInStatusBar(int n, int n2, int n3) {
        int n4 = n3 >>> 24 & 0xFF;
        int n5 = n3 >>> 16 & 0xFF;
        int n6 = n3 >>> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        StringBuilder stringBuilder = new StringBuilder().append("x = ").append(n).append(", y = ").append(n2).append(", alpha = ").append(n4).append(", red = ").append(n5).append(", green = ").append(n6).append(", blue = ").append(n7);
        String string = stringBuilder.toString();
        AppLogic.setStatusMessage(string);
    }
}

