/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Color;
import pixelitor.tools.FgBgColorSelector;

public enum GradientColorType {
    FG_TO_BG{

        public String toString() {
            return "Foreground to Background";
        }

        @Override
        public Color getStartColor() {
            if (this.isInverted()) {
                return FgBgColorSelector.getBG();
            }
            return FgBgColorSelector.getFG();
        }

        @Override
        public Color getEndColor() {
            if (this.isInverted()) {
                return FgBgColorSelector.getFG();
            }
            return FgBgColorSelector.getBG();
        }
    }
    ,
    FG_TO_TRANSPARENT{
        private Color transparentColor = new Color(0, 0, 0, 0);

        public String toString() {
            return "Foreground to Transparent";
        }

        @Override
        public Color getStartColor() {
            if (this.isInverted()) {
                return this.transparentColor;
            }
            return FgBgColorSelector.getFG();
        }

        @Override
        public Color getEndColor() {
            if (this.isInverted()) {
                return FgBgColorSelector.getFG();
            }
            return this.transparentColor;
        }
    }
    ,
    BLACK_TO_WHITE{

        public String toString() {
            return "Black to White";
        }

        @Override
        public Color getStartColor() {
            if (this.isInverted()) {
                return Color.WHITE;
            }
            return Color.BLACK;
        }

        @Override
        public Color getEndColor() {
            if (this.isInverted()) {
                return Color.BLACK;
            }
            return Color.WHITE;
        }
    };

    private boolean invert;

    public abstract Color getStartColor();

    public abstract Color getEndColor();

    public boolean isInverted() {
        return this.invert;
    }

    public void setInvert(boolean bl) {
        this.invert = bl;
    }
}

