/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools.toolhandlers;

import java.awt.event.MouseEvent;
import pixelitor.ImageComponent;

public abstract class ToolEventHandler {
    private ToolEventHandler successor;

    public void setSuccessor(ToolEventHandler toolEventHandler) {
        this.successor = toolEventHandler;
    }

    public void handleMousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (this.mousePressed(mouseEvent, imageComponent)) {
            return;
        }
        this.successor.handleMousePressed(mouseEvent, imageComponent);
    }

    abstract boolean mousePressed(MouseEvent var1, ImageComponent var2);

    public void handleMouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (this.mouseDragged(mouseEvent, imageComponent)) {
            return;
        }
        this.successor.handleMouseDragged(mouseEvent, imageComponent);
    }

    abstract boolean mouseDragged(MouseEvent var1, ImageComponent var2);

    public void handleMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (this.mouseReleased(mouseEvent, imageComponent)) {
            return;
        }
        this.successor.handleMouseReleased(mouseEvent, imageComponent);
    }

    abstract boolean mouseReleased(MouseEvent var1, ImageComponent var2);
}

