/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pixelitor.Composition;
import pixelitor.utils.HistogramPainter;
import pixelitor.utils.ImageSwitchListener;
import pixelitor.utils.ImageUtils;

public class HistogramsPanel
extends JPanel
implements ImageSwitchListener {
    public static final HistogramsPanel INSTANCE = new HistogramsPanel();
    private HistogramPainter red;
    private HistogramPainter green;
    private HistogramPainter blue;

    private HistogramsPanel() {
        this.setLayout(new BorderLayout());
        this.red = new HistogramPainter(Color.red);
        this.green = new HistogramPainter(Color.green);
        this.blue = new HistogramPainter(Color.blue);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setPreferredSize(new Dimension(256, 300));
        jPanel.setMinimumSize(new Dimension(256, 300));
        jPanel.add(this.red);
        jPanel.add(this.green);
        jPanel.add(this.blue);
        this.setBorder(BorderFactory.createTitledBorder("Histograms"));
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.add((Component)jScrollPane, "Center");
    }

    public boolean areHistogramsShown() {
        return this.getParent() != null;
    }

    @Override
    public void noOpenImageAnymore() {
        this.red.updateWithNothing();
        this.green.updateWithNothing();
        this.blue.updateWithNothing();
        this.repaint();
    }

    @Override
    public void newImageOpened() {
    }

    @Override
    public void activeCompositionHasChanged(Composition composition) {
        this.updateFromCompIfShown(composition);
    }

    public void updateFromCompIfShown(Composition composition) {
        int[] nArray;
        if (composition == null) {
            throw new IllegalArgumentException("trying to update with null comp");
        }
        if (!this.areHistogramsShown()) {
            return;
        }
        BufferedImage bufferedImage = composition.getCompositeImage();
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        int[] nArray4 = new int[256];
        int[] nArray5 = nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int n = nArray5.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray5[i];
            int n3 = n2 >>> 16 & 0xFF;
            int n4 = n2 >>> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            int n6 = n3;
            nArray2[n6] = nArray2[n6] + 1;
            int n7 = n4;
            nArray4[n7] = nArray4[n7] + 1;
            int n8 = n5;
            nArray3[n8] = nArray3[n8] + 1;
        }
        boolean bl = false;
        if (bl) {
            for (n = 0; n < 256; ++n) {
                nArray2[n] = (int)(1000.0 * Math.log(nArray2[n]));
                nArray4[n] = (int)(1000.0 * Math.log(nArray4[n]));
                nArray3[n] = (int)(1000.0 * Math.log(nArray3[n]));
            }
        }
        this.red.updateData(nArray2);
        this.green.updateData(nArray4);
        this.blue.updateData(nArray3);
        this.repaint();
    }
}

