/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.debug;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import javax.swing.tree.MutableTreeNode;
import pixelitor.Composition;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.Layer;
import pixelitor.utils.debug.BufferedImageNode;
import pixelitor.utils.debug.DebugNode;
import pixelitor.utils.debug.ImageLayerNode;
import pixelitor.utils.debug.SelectionNode;

public class CompositionNode
extends DebugNode {
    public CompositionNode(Composition composition) {
        super("Composition", composition);
        Serializable serializable;
        Object object;
        Serializable serializable2;
        int n = composition.getNrLayers();
        Layer layer = composition.getActiveLayer();
        for (int i = 0; i < n; ++i) {
            serializable2 = composition.getLayer(i);
            if (!(serializable2 instanceof ImageLayer)) continue;
            object = (ImageLayer)serializable2;
            serializable = object == layer ? new ImageLayerNode("ACTIVE Layer - " + ((Layer)serializable2).getName(), (ImageLayer)object) : new ImageLayerNode("Layer - " + ((Layer)serializable2).getName(), (ImageLayer)object);
            this.add((MutableTreeNode)((Object)serializable));
        }
        BufferedImage bufferedImage = composition.getCompositeImage();
        serializable2 = new BufferedImageNode("Composite Image", bufferedImage);
        this.add((MutableTreeNode)((Object)serializable2));
        this.addIntChild("nrLayers", n);
        this.addQuotedStringChild("name", composition.getName());
        object = "";
        serializable = composition.getFile();
        if (serializable != null) {
            object = ((File)serializable).getAbsolutePath();
        }
        this.addQuotedStringChild("file", (String)object);
        boolean bl = composition.isDirty();
        this.addBooleanChild("dirty", bl);
        boolean bl2 = composition.hasSelection();
        this.addBooleanChild("hasSelection", bl2);
        if (bl2) {
            SelectionNode selectionNode = new SelectionNode(composition.getSelection());
            this.add(selectionNode);
        }
        int n2 = composition.getCanvasWidth();
        this.addIntChild("canvasWidth", n2);
        int n3 = composition.getCanvasHeight();
        this.addIntChild("canvasHeight", n3);
    }
}

