/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.debug;

import java.awt.image.BufferedImage;
import pixelitor.layers.ImageLayer;
import pixelitor.utils.debug.BufferedImageNode;
import pixelitor.utils.debug.DebugNode;

public class ImageLayerNode
extends DebugNode {
    public ImageLayerNode(ImageLayer imageLayer) {
        this("Layer", imageLayer);
    }

    public ImageLayerNode(String string, ImageLayer imageLayer) {
        super(string, imageLayer);
        BufferedImage bufferedImage = imageLayer.getBufferedImage();
        this.add(new BufferedImageNode(bufferedImage));
        this.addFloatChild("opacity", imageLayer.getOpacity());
        this.addQuotedStringChild("BlendingMode", imageLayer.getBlendingMode().toString());
        this.addQuotedStringChild("name", imageLayer.getName());
        this.addIntChild("translationX", imageLayer.getTranslationX());
        this.addIntChild("translationY", imageLayer.getTranslationY());
    }
}

