/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.test;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import org.jdesktop.swingx.painter.effects.ShadowPathEffect;
import pixelitor.AppLogic;
import pixelitor.ChangeReason;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.FillType;
import pixelitor.NewImage;
import pixelitor.PixelitorWindow;
import pixelitor.automate.Automate;
import pixelitor.automate.SingleDirChooserPanel;
import pixelitor.filters.FillWithColorWheel;
import pixelitor.filters.ValueNoise;
import pixelitor.filters.jhlabsproxies.JHDropShadow;
import pixelitor.filters.jhlabsproxies.JHGaussianBlur;
import pixelitor.filters.painters.TextFilter;
import pixelitor.io.OpenSaveManager;
import pixelitor.io.OutputFormat;
import pixelitor.layers.AddNewLayerAction;
import pixelitor.layers.BlendingMode;
import pixelitor.layers.DeleteActiveLayerAction;
import pixelitor.layers.ImageLayer;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.utils.CompositionAction;
import pixelitor.utils.Utils;
import pixelitor.utils.test.ToolTests;

public class ImageTests {
    private ImageTests() {
    }

    public static void saveManySplashImages() {
        boolean bl = SingleDirChooserPanel.selectOutputDir(true);
        if (!bl) {
            return;
        }
        final ProgressMonitor progressMonitor = Utils.createProgressMonitor("Save Many Splash Images");
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                int n = 32;
                for (int i = 0; i < n; ++i) {
                    final OutputFormat outputFormat = OutputFormat.getLastOutputFormat();
                    final String string = String.format("splash%04d.%s", i, outputFormat.toString());
                    progressMonitor.setProgress((int)((float)i * 100.0f / (float)n));
                    progressMonitor.setNote("Creating " + string);
                    if (progressMonitor.isCanceled()) break;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ImageTests.createSplashImage();
                            File file = OpenSaveManager.getLastSaveDir();
                            File file2 = new File(file, string);
                            Composition composition = AppLogic.getActiveComp();
                            outputFormat.saveComposition(composition, file2);
                            AppLogic.getActiveImageComponent().close();
                            ValueNoise.reseed();
                        }
                    };
                    try {
                        EventQueue.invokeAndWait(runnable);
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        ExceptionHandler.showExceptionDialog(interruptedException);
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        ExceptionHandler.showExceptionDialog(invocationTargetException);
                    }
                }
                progressMonitor.close();
                return null;
            }
        };
        swingWorker.execute();
    }

    public static void createSplashImage() {
        assert (EventQueue.isDispatchThread());
        NewImage.addNewImage(FillType.WHITE, 400, 247, "Splash");
        Composition composition = AppLogic.getActiveComp();
        composition.getActiveLayer().setName("Color Wheel", true);
        new FillWithColorWheel().execute(ChangeReason.OP_WITHOUT_DIALOG);
        ImageTests.addNewLayer("Value Noise");
        ValueNoise valueNoise = new ValueNoise();
        valueNoise.setDetails(7);
        valueNoise.execute(ChangeReason.OP_WITHOUT_DIALOG);
        ImageLayer imageLayer = (ImageLayer)composition.getActiveLayer();
        imageLayer.setOpacity(0.3f, true, true);
        imageLayer.setBlendingMode(BlendingMode.SCREEN, true, true);
        ImageTests.addNewLayer("Gradient");
        ToolTests.addRadialBWGradientToActiveLayer(composition, true);
        imageLayer = (ImageLayer)composition.getActiveLayer();
        imageLayer.setOpacity(0.4f, true, true);
        imageLayer.setBlendingMode(BlendingMode.LUMINOSITY, true, true);
        FgBgColorSelector.INSTANCE.setFgColor(Color.WHITE);
        Font font = new Font("Comic Sans MS", 1, 42);
        ImageTests.addTextLayer(composition, "Pixelitor", font, -17, BlendingMode.NORMAL, 0.9f, false);
        ImageTests.addDropShadow();
        font = new Font("Comic Sans MS", 1, 24);
        ImageTests.addTextLayer(composition, "Loading...", font, -70, BlendingMode.NORMAL, 0.9f, false);
        ImageTests.addDropShadow();
        font = new Font("SansSerif", 0, 20);
        ImageTests.addTextLayer(composition, "version 1.1.2", font, 50, BlendingMode.NORMAL, 0.9f, false);
        ImageTests.addDropShadow();
    }

    public static void ioOverlayBlur() {
        boolean bl = Automate.selectInputAndOutputDir(false, "Overlay Blur - select the input and output folders");
        if (!bl) {
            return;
        }
        CompositionAction compositionAction = new CompositionAction(){

            @Override
            public void process(Composition composition) {
                composition.addNewLayerFromComposite("Overlay Blur");
                composition.getActiveLayer().setBlendingMode(BlendingMode.OVERLAY, true, true);
                JHGaussianBlur jHGaussianBlur = new JHGaussianBlur();
                jHGaussianBlur.setRadius(5);
                jHGaussianBlur.execute(ChangeReason.OP_WITHOUT_DIALOG);
            }
        };
        Automate.processEachFile(compositionAction, false, "Overlay Blur Progress");
    }

    private static void addDropShadow() {
        JHDropShadow jHDropShadow = new JHDropShadow();
        jHDropShadow.setDistance(5);
        jHDropShadow.setSoftness(5);
        jHDropShadow.setOpacity(0.8f);
        jHDropShadow.execute(ChangeReason.OP_WITHOUT_DIALOG);
    }

    private static void addNewLayer(String string) {
        AddNewLayerAction.INSTANCE.actionPerformed(new ActionEvent(PixelitorWindow.getInstance(), 0, string));
        AppLogic.getActiveLayer().setName(string, true);
    }

    public static void testLayers() {
        FgBgColorSelector.setBG(Color.WHITE);
        FgBgColorSelector.setFG(Color.BLACK);
        NewImage.addNewImage(FillType.TRANSPARENT, 400, 400, "Layer Test");
        Composition composition = AppLogic.getActiveComp();
        ImageTests.addTextLayer(composition, "this should be deleted", 0);
        ImageTests.addTextLayer(composition, "this should at the bottom", 100);
        composition.moveActiveLayerToBottom();
        composition.moveLayerSelectionUp();
        composition.moveLayerSelectionUp();
        DeleteActiveLayerAction.INSTANCE.actionPerformed(null);
        ImageTests.addTextLayer(composition, "this should at the top", -100);
        ImageTests.addTextLayer(composition, "this should be selected", 50);
        composition.moveActiveLayerDown();
        composition.imageChanged(true, true);
    }

    private static void addTextLayer(Composition composition, String string, int n) {
        Font font = new Font("SansSerif", 1, 20);
        ImageTests.addTextLayer(composition, string, font, n, BlendingMode.NORMAL, 1.0f, false);
    }

    private static void addTextLayer(Composition composition, String string, Font font, int n, BlendingMode blendingMode, float f, boolean bl) {
        ImageTests.addNewLayer(string);
        TextFilter textFilter = TextFilter.INSTANCE;
        textFilter.setText(string);
        textFilter.setFont(font);
        textFilter.setAreaEffects(null);
        textFilter.setWatermark(false);
        textFilter.setHorizontalAlignment(AbstractLayoutPainter.HorizontalAlignment.CENTER);
        textFilter.setVerticalAlignment(AbstractLayoutPainter.VerticalAlignment.CENTER);
        if (bl) {
            textFilter.setAreaEffects(new AreaEffect[]{new ShadowPathEffect()});
        }
        textFilter.execute(ChangeReason.OP_WITHOUT_DIALOG);
        ImageLayer imageLayer = (ImageLayer)composition.getActiveLayer();
        imageLayer.setTranslationY(n);
        imageLayer.enlargeLayer();
        imageLayer.setOpacity(f, true, true);
        imageLayer.setBlendingMode(blendingMode, true, true);
    }
}

