/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.test;

import java.awt.AlphaComposite;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.util.Random;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.FillType;
import pixelitor.ImageComponent;
import pixelitor.NewImage;
import pixelitor.layers.ImageLayer;
import pixelitor.tools.AbstractBrushTool;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.tools.GradientColorType;
import pixelitor.tools.GradientTool;
import pixelitor.tools.GradientType;
import pixelitor.tools.MoveTool;
import pixelitor.tools.ShapeType;
import pixelitor.tools.ShapesTool;
import pixelitor.tools.Tools;
import pixelitor.tools.UserDrag;
import pixelitor.utils.Utils;

public class ToolTests {
    private ToolTests() {
    }

    public static void testTools() {
        NewImage.addNewImage(FillType.WHITE, 400, 400, "Tool Tests");
        ImageComponent imageComponent = AppLogic.getActiveImageComponent();
        Composition composition = imageComponent.getComp();
        ToolTests.addRadialBWGradientToActiveLayer(composition, true);
        int n = 20;
        int n2 = 20;
        ToolTests.paintDiagonals(Tools.ERASER, composition, n, n2);
        ToolTests.paintImageFrame(Tools.BRUSH, composition, n, n2);
        ToolTests.paintHeartShape(composition);
        MoveTool.move(composition, 40, 40);
        imageComponent.repaint();
    }

    private static void paintHeartShape(Composition composition) {
        ShapesTool shapesTool = Tools.SHAPES;
        int n = composition.getCanvasWidth();
        int n2 = composition.getCanvasHeight();
        UserDrag userDrag = new UserDrag((int)((double)n * 0.25), (int)((double)n2 * 0.25), (int)((double)n * 0.75), (int)((double)n2 * 0.75));
        shapesTool.setShapeType(ShapeType.HEART);
        shapesTool.paintShapeOnIC(composition, userDrag);
    }

    private static void paintDiagonals(AbstractBrushTool abstractBrushTool, Composition composition, int n, int n2) {
        int n3 = composition.getCanvasWidth();
        int n4 = composition.getCanvasHeight();
        Point point = new Point(n, n2);
        Point point2 = new Point(n3 - n, n2);
        Point point3 = new Point(n3 - n, n4 - n2);
        Point point4 = new Point(n, n4 - n2);
        abstractBrushTool.drawBrushStrokeProgrammatically(composition, point, point3);
        abstractBrushTool.drawBrushStrokeProgrammatically(composition, point2, point4);
    }

    private static void paintImageFrame(AbstractBrushTool abstractBrushTool, Composition composition, int n, int n2) {
        int n3 = composition.getCanvasWidth();
        int n4 = composition.getCanvasHeight();
        Point point = new Point(n, n2);
        Point point2 = new Point(n3 - n, n2);
        Point point3 = new Point(n3 - n, n4 - n2);
        Point point4 = new Point(n, n4 - n2);
        abstractBrushTool.drawBrushStrokeProgrammatically(composition, point, point2);
        abstractBrushTool.drawBrushStrokeProgrammatically(composition, point2, point3);
        abstractBrushTool.drawBrushStrokeProgrammatically(composition, point3, point4);
        abstractBrushTool.drawBrushStrokeProgrammatically(composition, point4, point);
    }

    public static void addRadialBWGradientToActiveLayer(Composition composition, boolean bl) {
        int n = composition.getCanvasWidth();
        int n2 = composition.getCanvasHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = 0;
        int n6 = 0;
        if (n > n2) {
            n5 = n3;
        } else {
            n6 = n4;
        }
        GradientType gradientType = bl ? GradientType.RADIAL : GradientType.SPIRAL_CW;
        GradientTool.drawGradient((ImageLayer)composition.getActiveLayer(), gradientType, GradientColorType.BLACK_TO_WHITE, MultipleGradientPaint.CycleMethod.REFLECT, AlphaComposite.SrcOver, new UserDrag(n3, n4, n5, n6), false);
    }

    public static void randomToolActions() {
        final Composition composition = AppLogic.getActiveComp();
        final Random random = new Random();
        if (composition != null) {
            final int n = composition.getCanvasWidth();
            final int n2 = composition.getCanvasHeight();
            final ProgressMonitor progressMonitor = Utils.createProgressMonitor("1001 Tool Actions");
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    Random random2 = new Random();
                    block4: for (int i = 0; i < 1001; ++i) {
                        progressMonitor.setProgress((int)((float)i * 100.0f / 1001.0f));
                        if (progressMonitor.isCanceled()) break;
                        FgBgColorSelector.setRandomColors();
                        Point point = new Point(random.nextInt(n), random.nextInt(n2));
                        Point point2 = new Point(random.nextInt(n), random.nextInt(n2));
                        int n3 = random2.nextInt(2);
                        switch (n3) {
                            case 0: {
                                Tools.BRUSH.randomize();
                                Tools.BRUSH.drawBrushStrokeProgrammatically(composition, point, point2);
                                continue block4;
                            }
                            case 1: {
                                Tools.SHAPES.randomize();
                                Tools.SHAPES.paintShapeOnIC(composition, new UserDrag(point.x, point.y, point2.x, point2.y));
                                continue block4;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    progressMonitor.close();
                    return null;
                }
            };
            swingWorker.execute();
        }
    }
}

