#include <pnm.h>
/* User-defined information goes here... intrinsic information follows the
   string "DO NOT MODIFY PAST HERE"*/
/* DO NOT MODIFY PAST HERE */
typedef short unsigned int uns_int;
#define UNS_PPM_FORMAT RPPM_FORMAT
#define MAXAREA 4096*4096
/* Reasonable minimum value for a float.*/
#define MIN_VALUE 1E-30
typedef float uns_float;
#define PI 3.14159265358979323846
/* 3-D array*/
typedef uns_int*** uns_int3;
/* 4-D array*/
typedef uns_float**** uns_float4;
typedef double**** uns_double4;
typedef uns_float fft_float;
/* Image structure*/
struct UnshakeRaster {
  uns_int3 raster;
  int colours;
  int width;
  int height;
};
struct UnshakeGeom {
  int width;
  int height;
  int x;
  int y;
};
/* Unshake parameters (of the image analysis). Quasi-global quantities.*/
struct UP {
  unsigned int blur;
  int care;
  int autoMode;
  int flatWin;
  double ACTIND;
  double relNoise;
  int nKernSize;
  int kernSize;
  char* comment;
  double brightness[4];
  uns_float4 space;
  uns_float** buffer;
  uns_float** activity;
  uns_float** acTab;
  double*** kernel;
  double lastKernWidth;
  double lastKernHeight;
  double currai;
  double recoverTime;

};

/* Failure to open file*/
#define UNS_NO_FILE 2;
/* Failure to allocate array*/
#define UNS_OOM 3;
/* Coding error */
#define UNS_CODE 3;
#define freeUns(array) free_Uns(array); array = (void*) NULL;
/* So who nicked interger minimisation?*/
#define uns_min(a, b) (a>b? b: a)
#define uns_max(a, b) (a>b? a: b)
void free_Uns ARGS ((void* raster));
int fileToURas ARGS ((char* URLString, struct UnshakeRaster* image));
int filepToURas ARGS ((FILE* infile, struct UnshakeRaster* image));
int saveURas ARGS((FILE* stream, struct UnshakeRaster* image));
uns_int3 new3DInt ARGS((uns_int3 array, int a, int b, int c));
uns_float4 new4DFloat ARGS((uns_float4 array, int a, int b, int c, int d));
double**** new4DDouble ARGS ((double**** array, int a, int b, int c, int d));
int UnshakeBasic ARGS((uns_int3 kernelRaster, int width, int height,
		       uns_int3 imageRaster, int imWidth, int imHeight,
		       int colours,
		       struct UP* parameters));
int getPow2 ARGS ((int val));
int getSize ARGS ((int val));
int getKernImage ARGS ((struct UnshakeRaster* image,
			struct UnshakeRaster* kImage,
			struct UP* params, struct UnshakeGeom* kgeom));
void getParams ARGS ((struct UP* params, int nWidth, int nHeight));
void paramInit ARGS ((struct UP* params));
void URasToFloat ARGS ((struct UP* params,
		      struct UnshakeRaster* wras
		      , int width, int height, int fullWidth, int fullHeight));
double floatToURas ARGS ((struct UP* params, struct UnshakeRaster* wras
			  , struct UnshakeRaster* wras1
			  , int width, int height, int fullWidth
			  , int fullHeight, int widIn, int heiIn));
void steven ARGS ((struct UP* params,  struct UnshakeRaster* wras,
		   int width, int height, int fullWidth, int fullHeight));
void translateSpace ARGS ((struct UP* params, int nWidth,
			   int nHeight, int deltai, int deltaj, int nColour));
void twoDFFT ARGS ((struct UP* params, int nWidth, int nHeight, int nCol));
void FFT ARGS ((fft_float** array, int NB));
void ITwoDFFT ARGS ((struct UP* params, int nWidth, int nHeight, int nCol));
void IFFT ARGS ((fft_float** array, int NB));
int bitRev ARGS ((int J, int NBITS));
void maskSpace ARGS ((struct UP* params, int widCentre
	       , int widMax, int widInner, int heiCentre, int heiMax
		      , int nCol, int width, int height));
void maskKernSpaceRaw ARGS ((struct UP* params, int widCentre, int widMax,
			     int widInner,
			     int heiCentre, int heiMax, int nCol, int width,
			     int height));
void getActivity ARGS ((struct UP* params, int nWidth, int nHeight
			, int imWidth, int imHeight));
void getAcTab ARGS ((struct UP* params, int nWidth, int nHeight, double norm));
void getAcTab3 ARGS ((struct UP* params, int nWidth, int nHeight,
		      double norm));
double guessActind ARGS ((struct UP* params, int nWidth, int nHeight));
void flipAcTab ARGS ((struct UP* params, int nWidth, int nHeight));
int deConvolve ARGS ((struct UP* params, struct UnshakeRaster* wras1
		      , int phaseKnown));
int expandKern5 ARGS ((struct UP* params, double*** lkval,
			      double*** lkval1,
			      int nWidth, int nHeight, int a, int b));
void maskSpaceRect ARGS ((struct UP* params, int widCentre
		   , int widMax, int widInner, int heiCentre, int heiMax
			  , int heiInner, int width, int height));
void replaceBrightness ARGS ((struct UP* params, int nWidth, int nHeight
			      , int nCol)); 

double getWiener ARGS ((double*** kval, int nWidth, int nHeight, double na));
void doDeConvolve ARGS ((struct UP* params, int nWidth, int nHeight
			 , int nCol, double nsr));
double getNoiseAmp ARGS ((double*** kval, int nWidth, int nHeight, double nl));
void redress ARGS ((struct UP* params, struct UnshakeRaster* wr, int fullWidth
		    , int fullHeight, int widIn, int heiIn));
double sharpness ARGS ((struct UP* params, int width, int height));
void invertKern ARGS ((struct UP* params, int nWidth, int nHeight));
