/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.CaptionNumericTextField;
import WaterMarker.RescaleImage;
import WatermarkHelper.JFontChooser;
import WatermarkHelper.WaterMarkHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CaptionGUI
extends JFrame {
    WaterMarkHelper captionHelper;
    Font textFont = null;
    Color textColor = null;
    ArrayList inputFileList = null;
    JPanel[] jFileListPanel;
    JLabel[] jFileListLabel;
    boolean isUpdate = false;
    int updateIndex;
    int currentIndex = 0;
    private JColorChooser jFColorChooser1;
    private JTextField HSpaceTextField;
    private JLabel HspaceLabel;
    private JLabel ImagePanel;
    private JTextField VSpaceTextField;
    private JLabel VspaceLabel;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSlider jSlider1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField4;
    private JTextField jTextField5;

    public CaptionGUI(WaterMarkHelper helper, boolean Update, int Index) {
        this.captionHelper = helper;
        this.captionHelper.getMainStatus().setText(this.captionHelper.getProperty("message.caption.open"));
        this.isUpdate = Update;
        this.updateIndex = Index;
        this.initComponents();
    }

    public CaptionGUI(WaterMarkHelper helper) {
        this.captionHelper = helper;
        this.captionHelper.getMainStatus().setText(this.captionHelper.getProperty("message.caption.open"));
        this.initComponents();
    }

    private void initComponents() {
        ArrayList watermarkerList = this.captionHelper.getWaterMarkerList();
        int indexCount = 0;
        for (ArrayList currentWatermarker : watermarkerList) {
            if (currentWatermarker.get(0).toString().equalsIgnoreCase("CAPTION")) {
                this.isUpdate = true;
                this.updateIndex = indexCount;
                break;
            }
            ++indexCount;
        }
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel7 = new JPanel();
        this.ImagePanel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jSlider1 = new JSlider();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton5 = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.HspaceLabel = new JLabel();
        this.VspaceLabel = new JLabel();
        this.jTextField4 = new CaptionNumericTextField();
        this.jTextField5 = new CaptionNumericTextField();
        this.HSpaceTextField = new CaptionNumericTextField();
        this.VSpaceTextField = new CaptionNumericTextField();
        this.jButton4 = new JButton();
        this.jButton3 = new JButton();
        this.textColor = new Color(0, 0, 0);
        this.textFont = new Font("Arial", 1, 12);
        this.setTitle(this.captionHelper.getProperty("title.caption.gui"));
        this.setDefaultCloseOperation(0);
        this.setBackground(new Color(51, 51, 51));
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Frame frame = (Frame)evt.getSource();
                frame.dispose();
                CaptionGUI.this.captionHelper.setEnable(CaptionGUI.this.captionHelper.getMainFrame());
                CaptionGUI.this.captionHelper.getMainStatus().setText(CaptionGUI.this.captionHelper.getProperty("message.caption.close"));
            }
        });
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jLabel1.setBackground(new Color(204, 204, 204));
        this.jLabel1.setFont(new Font("Palatino Linotype", 0, 18));
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("Caption Watermarker");
        this.jLabel2.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel2.setForeground(new Color(255, 102, 0));
        this.jLabel2.setText("[?]");
        this.jLabel2.setToolTipText(this.captionHelper.getProperty("help.caption"));
        this.jPanel3.setBackground(new Color(51, 51, 51));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Images List", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jPanel7.setBackground(new Color(51, 51, 51));
        this.jPanel7.setBorder(BorderFactory.createLineBorder(new Color(0, 153, 255)));
        this.jPanel7.setForeground(new Color(51, 51, 51));
        this.ImagePanel.setHorizontalAlignment(0);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ImagePanel, -1, 120, Short.MAX_VALUE));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ImagePanel, -1, 100, Short.MAX_VALUE));
        this.jPanel5.setBackground(new Color(51, 51, 51));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 288, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 112, Short.MAX_VALUE));
        this.jScrollPane2.setViewportView(this.jPanel5);
        this.jLabel4.setFont(new Font("Palatino Linotype", 0, 10));
        this.jLabel4.setForeground(new Color(0, 153, 255));
        this.jLabel4.setText("File");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -1, 440, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 312, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel7, -2, -1, -2).addComponent(this.jScrollPane2, -2, 113, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -1, 14, Short.MAX_VALUE).addGap(12, 12, 12)));
        this.jPanel2.setBackground(new Color(51, 51, 51));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Set Details", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        String[] text = (String[])this.captionHelper.getInputFilesCaption().get(0);
        if (text[0] != null) {
            String textValue = "";
            for (int i = 0; i < text.length; ++i) {
                textValue = textValue + text[i] + "\n";
            }
            this.jTextArea1.setText(textValue);
        } else {
            this.jTextArea1.setText("");
        }
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jLabel3.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel3.setForeground(new Color(204, 204, 204));
        this.jLabel3.setText("Fill");
        this.jTextField1.setText("100%");
        this.jTextField1.setEditable(false);
        this.jSlider1.setMinimum(5);
        this.jSlider1.setValue(100);
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CaptionGUI.this.FillChangeAction(evt);
            }
        });
        this.jButton1.setText("Choose Color");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CaptionGUI.this.chooseColourAction(evt);
            }
        });
        this.jButton2.setText("Choose Font");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CaptionGUI.this.selectFontAction(evt);
            }
        });
        this.jButton5.setText("Save Caption");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CaptionGUI.this.SetCaption(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2).addGap(8, 8, 8).addComponent(this.jSlider1, -1, 275, Short.MAX_VALUE).addGap(6, 6, 6).addComponent(this.jButton1)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 337, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jButton5, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSlider1, 0, 0, Short.MAX_VALUE).addComponent(this.jButton1).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField1, -1, 23, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton5)).addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBackground(new Color(51, 51, 51));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Position Details", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jLabel8.setForeground(new Color(204, 204, 204));
        this.jLabel8.setText("Choose Position");
        this.jLabel9.setBackground(new Color(204, 204, 204));
        this.jLabel9.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel9.setForeground(new Color(204, 204, 204));
        this.jLabel9.setText("X");
        this.jLabel10.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel10.setForeground(new Color(204, 204, 204));
        this.jLabel10.setText("Y");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Top Left", "Top Center", "Top Right", "Middle Left", "Middle Center", "Middle Right", "Bottom Left", "Bottom Center", "Bottom Right", "Coustome"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CaptionGUI.this.checkCoustomePositon(evt);
            }
        });
        this.HspaceLabel.setFont(new Font("Palatino Linotype", 0, 11));
        this.HspaceLabel.setForeground(new Color(204, 204, 204));
        this.HspaceLabel.setText("Space from Left Edge");
        this.VspaceLabel.setFont(new Font("Palatino Linotype", 0, 11));
        this.VspaceLabel.setForeground(new Color(204, 204, 204));
        this.VspaceLabel.setText("Space from Top Edge");
        this.jTextField4.setToolTipText("X position");
        this.jTextField4.setEnabled(false);
        this.jTextField4.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                CaptionGUI.this.XcheckNumber(evt);
            }
        });
        this.jTextField5.setToolTipText("Y position");
        this.jTextField5.setEnabled(false);
        this.jTextField5.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                CaptionGUI.this.YcheckNumber(evt);
            }
        });
        this.HSpaceTextField.setText("0");
        this.HSpaceTextField.setToolTipText("Set Horizontal spacing (pix) from image Edge");
        this.HSpaceTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                CaptionGUI.this.HspaceNumberCheck(evt);
            }
        });
        this.VSpaceTextField.setText("0");
        this.VSpaceTextField.setToolTipText("Set Vertical spacing (pix) from image Edge");
        this.VSpaceTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                CaptionGUI.this.VspaceNumberCheck(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9)).addGap(33, 33, 33).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField4, 0, 0, Short.MAX_VALUE).addComponent(this.jTextField5, -2, 41, -2)))).addGap(70, 70, 70).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBox1, 0, 287, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.VspaceLabel, -1, 241, Short.MAX_VALUE).addComponent(this.HspaceLabel, GroupLayout.Alignment.TRAILING, -1, 241, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.VSpaceTextField).addComponent(this.HSpaceTextField, -2, 42, -2)))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.HSpaceTextField, -2, -1, -2).addComponent(this.HspaceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField5, -2, -1, -2).addComponent(this.VSpaceTextField, -2, -1, -2).addComponent(this.VspaceLabel)).addComponent(this.jLabel10)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton4.setText("Cancel");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CaptionGUI.this.CancelFont(evt);
            }
        });
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CaptionGUI.this.AddCaptionWatermarker(evt);
            }
        });
        if (this.isUpdate) {
            ArrayList EditList = (ArrayList)this.captionHelper.getWaterMarkerList().get(this.updateIndex);
            int Fill = Integer.parseInt(EditList.get(9).toString());
            Font f = (Font)EditList.get(7);
            Color c = (Color)EditList.get(8);
            String imagePosition = EditList.get(10).toString();
            String X = EditList.get(11).toString();
            String Y = EditList.get(12).toString();
            String hSpace = EditList.get(13).toString();
            String vSpace = EditList.get(14).toString();
            this.jTextField4.setText(X);
            this.jTextField5.setText(Y);
            this.jSlider1.setValue(Fill);
            this.jTextArea1.setFont(f);
            this.jTextArea1.setForeground(c);
            this.jComboBox1.setSelectedItem(imagePosition);
            this.jTextField1.setText(String.valueOf(Fill) + "%");
            this.HSpaceTextField.setText(hSpace);
            this.VSpaceTextField.setText(vSpace);
            this.jButton3.setText("Update");
        } else {
            this.jTextArea1.setFont(this.textFont);
            this.jTextArea1.setForeground(this.textColor);
            this.jTextField5.setText("0");
            this.jTextField4.setText("0");
            this.HSpaceTextField.setText("0");
            this.VSpaceTextField.setText("0");
            this.jSlider1.setValue(100);
            this.jTextField1.setText("100%");
            this.jButton3.setText("Add");
        }
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(137, 137, 137).addComponent(this.jLabel2)).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(85, 85, 85).addComponent(this.jButton3, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 195, Short.MAX_VALUE).addComponent(this.jButton4).addGap(79, 79, 79)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGap(1, 1, 1).addComponent(this.jPanel3, -2, 155, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(4, 4, 4).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4).addComponent(this.jButton3)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(29, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(20, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 525) / 2, (screenSize.height - 537) / 2, 525, 537);
        this.inputFileList = this.captionHelper.getInputFiles();
        this.jFileListPanel = new JPanel[this.inputFileList.size()];
        this.jFileListLabel = new JLabel[this.inputFileList.size()];
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 1));
        int i = 0;
        Iterator it = this.inputFileList.iterator();
        while (it.hasNext()) {
            this.jFileListPanel[i] = new JPanel();
            this.jFileListPanel[i].setBackground(new Color(51, 51, 51));
            this.jFileListPanel[i].setLayout(new BoxLayout(this.jFileListPanel[i], 1));
            this.jFileListLabel[i] = new JLabel();
            File inputfile = (File)it.next();
            String texts = inputfile.getPath();
            this.jFileListLabel[i].setText(texts);
            final int index = i;
            this.jFileListLabel[i].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    CaptionGUI.this.SetSelection(evt, index);
                }
            });
            this.jFileListLabel[i].setForeground(new Color(255, 153, 0));
            this.jFileListPanel[i].add(this.jFileListLabel[i]);
            this.jPanel5.add(this.jFileListPanel[i]);
            this.jPanel5.revalidate();
            this.jPanel5.repaint();
            ++i;
        }
        this.jFileListPanel[0].setBackground(new Color(255, 255, 153));
        File firstImage = (File)this.inputFileList.get(0);
        BufferedImage image = this.captionHelper.getPreview(firstImage);
        String selectedFilePath = firstImage.getPath();
        if (selectedFilePath.length() > 70) {
            selectedFilePath = selectedFilePath.substring(0, 70) + "...";
        }
        this.jLabel4.setText(selectedFilePath);
        RescaleImage previewImage = new RescaleImage();
        BufferedImage result = previewImage.RescaleImage(this.captionHelper, image, 90.0, 120.0);
        ImageIcon i2i = new ImageIcon(result);
        this.ImagePanel.setIcon(i2i);
        this.jPanel7.repaint();
        this.jPanel7.revalidate();
    }

    private void FillChangeAction(ChangeEvent evt) {
        this.captionHelper.sliderChangeAction(this.jSlider1, this.jTextField1);
    }

    private void chooseColourAction(ActionEvent evt) {
        this.jFColorChooser1 = new JColorChooser();
        this.textColor = JColorChooser.showDialog(this, "Choose Color", this.jTextArea1.getBackground());
        if (this.textColor != null) {
            this.jTextArea1.setForeground(this.textColor);
        } else {
            this.textColor = this.jTextArea1.getBackground();
        }
    }

    private void selectFontAction(ActionEvent evt) {
        JFontChooser chooser = new JFontChooser(this.jTextArea1.getFont());
        if (chooser.showDialog(this, "Choose a font...") == 2 && this.textFont != null) {
            this.textFont = chooser.getSelectedFont();
            this.jTextArea1.setFont(this.textFont);
        }
    }

    private void checkCoustomePositon(ActionEvent evt) {
        if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Coustome")) {
            this.jTextField4.setEnabled(true);
            this.jTextField5.setEnabled(true);
            this.VSpaceTextField.setEnabled(false);
            this.VSpaceTextField.setText("0");
            this.HSpaceTextField.setEnabled(false);
            this.HSpaceTextField.setText("0");
            this.HspaceLabel.setText("Not Applicable");
            this.VspaceLabel.setText("Not Applicable");
        } else {
            this.jTextField4.setEnabled(false);
            this.jTextField4.setText("0");
            this.jTextField5.setEnabled(false);
            this.jTextField5.setText("0");
            if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Top Left")) {
                this.HspaceLabel.setText("Space from Left Edge");
                this.VspaceLabel.setText("Space from Top Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Top Center")) {
                this.HspaceLabel.setText("Not Applicable");
                this.HSpaceTextField.setEnabled(false);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Top Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Top Right")) {
                this.HspaceLabel.setText("Space from Right Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Top Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Middle Left")) {
                this.HspaceLabel.setText("Space from Left Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Not Applicable");
                this.VSpaceTextField.setEnabled(false);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Middle Center")) {
                this.HspaceLabel.setText("Not Applicable");
                this.HSpaceTextField.setEnabled(false);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Not Applicable");
                this.VSpaceTextField.setEnabled(false);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Middle Right")) {
                this.HspaceLabel.setText("Space from Right Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Not Applicable");
                this.VSpaceTextField.setEnabled(false);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Bottom Left")) {
                this.HspaceLabel.setText("Space from Left Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Bottom Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Bottom Center")) {
                this.HspaceLabel.setText("Not Applicable");
                this.HSpaceTextField.setEnabled(false);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Bottom Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Bottom Right")) {
                this.HspaceLabel.setText("Space from Right Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Bottom Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            }
        }
    }

    private void XcheckNumber(FocusEvent evt) {
        this.captionHelper.checkNumber(this.jTextField4);
    }

    private void YcheckNumber(FocusEvent evt) {
        this.captionHelper.checkNumber(this.jTextField5);
    }

    private void HspaceNumberCheck(FocusEvent evt) {
        this.captionHelper.checkNumber(this.HSpaceTextField);
    }

    private void VspaceNumberCheck(FocusEvent evt) {
        this.captionHelper.checkNumber(this.VSpaceTextField);
    }

    private void CancelFont(ActionEvent evt) {
        this.dispose();
        this.captionHelper.setEnable(this.captionHelper.getMainFrame());
        this.captionHelper.getMainStatus().setText(this.captionHelper.getProperty("message.caption.close"));
    }

    private void SetSelection(MouseEvent evt, int index) {
        this.currentIndex = index;
        File firstImage = (File)this.captionHelper.getInputFiles().get(index);
        BufferedImage image = this.captionHelper.getPreview(firstImage);
        String selectedFilePath = firstImage.getPath();
        if (selectedFilePath.length() > 70) {
            selectedFilePath = selectedFilePath.substring(0, 70) + "...";
        }
        this.jLabel4.setText(selectedFilePath);
        for (int x = 0; x < this.jFileListPanel.length; ++x) {
            this.jFileListPanel[x].setBackground(new Color(51, 51, 51));
        }
        this.jFileListPanel[index].setBackground(new Color(255, 255, 153));
        RescaleImage previewImage = new RescaleImage();
        BufferedImage result = previewImage.RescaleImage(this.captionHelper, image, 90.0, 120.0);
        ImageIcon i2i = new ImageIcon(result);
        this.ImagePanel.setIcon(i2i);
        this.jPanel7.repaint();
        this.jPanel7.revalidate();
        String[] text = (String[])this.captionHelper.getInputFilesCaption().get(index);
        if (text[0] != null) {
            String textValue = "";
            for (int i = 0; i < text.length; ++i) {
                textValue = textValue + text[i] + "\n";
            }
            this.jTextArea1.setText(textValue);
        } else {
            this.jTextArea1.setText("");
        }
    }

    private void AddCaptionWatermarker(ActionEvent evt) {
        ArrayList<Object> CaptionData = new ArrayList<Object>();
        CaptionData.add("CAPTION");
        CaptionData.add(null);
        CaptionData.add(null);
        CaptionData.add(null);
        CaptionData.add(null);
        CaptionData.add(null);
        CaptionData.add(null);
        CaptionData.add(this.jTextArea1.getFont());
        CaptionData.add(this.jTextArea1.getForeground());
        CaptionData.add(this.jSlider1.getValue());
        CaptionData.add(this.jComboBox1.getSelectedItem().toString());
        CaptionData.add(this.jTextField4.getText());
        CaptionData.add(this.jTextField5.getText());
        CaptionData.add(this.HSpaceTextField.getText());
        CaptionData.add(this.VSpaceTextField.getText());
        if (this.isUpdate) {
            this.captionHelper.getWaterMarkerList().set(this.updateIndex, CaptionData);
            this.captionHelper.Info("Updating Caption Watermarker at Index:" + this.updateIndex + " with Parameters List: " + CaptionData);
        } else {
            this.captionHelper.getWaterMarkerList().add(CaptionData);
            this.captionHelper.Info("Updating Caption Watermarker at Index:" + this.updateIndex + " with Parameters List: " + CaptionData);
        }
        this.dispose();
        this.captionHelper.setEnable(this.captionHelper.getMainFrame());
        this.captionHelper.getMainWaterMarksDetails().removeAll();
        this.captionHelper.setWaterMarkDetails();
        this.captionHelper.getMainStatus().setText(this.captionHelper.getProperty("message.caption.success"));
    }

    private void SetCaption(ActionEvent evt) {
        int index = this.currentIndex;
        String text = this.jTextArea1.getText();
        String[] textString = text.split("\n");
        this.captionHelper.getInputFilesCaption().set(index, textString);
    }
}

