/*
 * Decompiled with CFR 0.152.
 */
package WaterMarker;

import WatermarkHelper.WaterMarkHelper;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class RescaleImage {
    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage RescaleImage(WaterMarkHelper helper, BufferedImage source, double MaxHeight, double MaxWidth) {
        try {
            double height = source.getHeight();
            double width = source.getWidth();
            String imageSizeString = helper.imageSize(height, width, MaxHeight, MaxWidth);
            String[] imageSize = imageSizeString.split("##@@##");
            height = Double.parseDouble(imageSize[0]);
            width = Double.parseDouble(imageSize[1]);
            Object interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            int sourceWidth = source.getWidth();
            int sourceHeight = source.getHeight();
            double xScale = width / (double)sourceWidth;
            double yScale = height / (double)sourceHeight;
            if (height <= 0.0) {
                xScale = yScale;
                width = (int)Math.rint(xScale * (double)sourceWidth);
            }
            if (height <= 0.0) {
                yScale = xScale;
                width = (int)Math.rint(yScale * (double)sourceHeight);
            }
            GraphicsConfiguration gc = RescaleImage.getDefaultConfiguration();
            BufferedImage result = gc.createCompatibleImage((int)width, (int)height, source.getColorModel().getTransparency());
            Graphics2D g2d = null;
            try {
                g2d = result.createGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
                AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
                g2d.drawRenderedImage(source, at);
            }
            finally {
                if (g2d != null) {
                    g2d.dispose();
                }
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

