/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.demosaic;

import it.tidalwave.imageio.rawprocessor.demosaic.BayerInfo;
import java.awt.image.Raster;

public abstract class DemosaicingFilter {
    private static final int SCALE = 1024;
    protected int redCoefficient = 1024;
    protected int greenCoefficient = 1024;
    protected int blueCoefficient = 1024;
    private int blackLevel;
    private short[] curve;
    protected static final int SHORT_MASK = 65535;

    public void setRedCoefficient(double red) {
        this.redCoefficient = (int)Math.round(red * 1024.0);
    }

    public void setGreenCoefficient(double green) {
        this.greenCoefficient = (int)Math.round(green * 1024.0);
    }

    public void setBlueCoefficient(double blue) {
        this.blueCoefficient = (int)Math.round(blue * 1024.0);
    }

    public void setBlackLevel(int blackLevel) {
        this.blackLevel = blackLevel;
    }

    public void setCurve(short[] curve) {
        assert (curve == null || curve.length == 65536);
        this.curve = curve;
    }

    protected short applyCoefficientAndCurve(int coefficient, int value) {
        if ((value -= this.blackLevel) < 0) {
            value = 0;
        }
        int n = value = (value = value * coefficient / 1024) < 65535 ? value : 65535;
        if (this.curve != null) {
            value = this.curve[value] & 0xFFFF;
        }
        return (short)value;
    }

    public abstract void filter(Raster var1, BayerInfo var2);
}

