/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.ResourceLoader;

public abstract class DrawAction
extends AbstractAction {
    private static HashMap instances = new HashMap();
    private KeyStroke[] keyStrokes = null;

    public DrawAction(String string) {
        super(string);
        DrawAction.addInstance(this);
    }

    public DrawAction(String string, String string2) {
        super(string, ResourceLoader.getImage("jdomain/jdraw/images/" + string2, 24));
        DrawAction.addInstance(this);
    }

    protected boolean changesImage() {
        return true;
    }

    public final String getToolTipText() {
        String string = (String)this.getValue("LongDescription");
        if (string != null) {
            return string;
        }
        return (String)this.getValue("Name");
    }

    protected final void setToolTipText(String string) {
        this.putValue("LongDescription", string);
    }

    private static void addInstance(DrawAction drawAction) {
        Assert.isNull(instances.get(drawAction.getClass()), "action: duplicate action");
        instances.put(drawAction.getClass(), drawAction);
    }

    public static DrawAction getAction(Class clazz) {
        try {
            DrawAction drawAction = (DrawAction)instances.get(clazz);
            if (drawAction == null) {
                drawAction = (DrawAction)clazz.newInstance();
                instances.put(clazz, drawAction);
            }
            return drawAction;
        }
        catch (Exception exception) {
            Log.exception(exception);
            return null;
        }
    }

    public final KeyStroke[] getAccelerators() {
        return this.keyStrokes;
    }

    protected final void setAccelerators(KeyStroke[] keyStrokeArray) {
        this.putValue("AcceleratorKey", keyStrokeArray[0]);
        if (keyStrokeArray.length > 0) {
            this.keyStrokes = keyStrokeArray;
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        this._actionPerformed(actionEvent);
    }

    protected void _actionPerformed(ActionEvent actionEvent) {
        if (this.changesImage()) {
            Log.debug(this.getClass().getName() + " changes image...");
            UndoManager.INSTANCE.setHasChanges(true);
        }
    }

    public final void actionPerformed() {
        if (this.isEnabled()) {
            this.actionPerformed(null);
        }
    }

    public boolean hasFinished() {
        return true;
    }

    public final boolean equals(Object object) {
        return object.getClass() == this.getClass();
    }

    public final int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

