/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.jdraw.gui.FillTool;
import jdomain.util.Util;
import jdomain.util.gui.WidgetFactory;

public final class ToleranceDialog
extends DrawDialog
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private final JTextField redField = new JTextField(6);
    private final JTextField greenField = new JTextField(6);
    private final JTextField blueField = new JTextField(6);
    private final JTextField alphaField = new JTextField(6);

    public ToleranceDialog() {
        super("Tolerance Dialog");
        this.setModal(true);
        this.setUndecorated(true);
        FillTool.Tolerance tolerance = FillTool.INSTANCE.getTolerance();
        this.redField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.redField.setText(String.valueOf(tolerance.redDiff));
        this.redField.getDocument().addDocumentListener(this);
        this.greenField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.greenField.setText(String.valueOf(tolerance.greenDiff));
        this.greenField.getDocument().addDocumentListener(this);
        this.blueField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.blueField.setText(String.valueOf(tolerance.blueDiff));
        this.blueField.getDocument().addDocumentListener(this);
        this.alphaField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.alphaField.setText(String.valueOf(tolerance.alphaDiff));
        this.alphaField.getDocument().addDocumentListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        JLabel jLabel = new JLabel("<html><b>Please enter fill tolerance values (0-255): </b></html>");
        jLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Red Tolerance:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.redField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Green Tolerance:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.greenField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Blue Tolerance:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.blueField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Alpha Tolerance:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.alphaField, gridBagConstraints);
        this.main.add((Component)jPanel, "Center");
        this.setDefaultBorder();
        this.addRightButton(this.getApproveButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addRightButton(this.getCancelButton());
        this.addButtonPanel();
        JButton jButton = new JButton("Reset");
        jButton.setMnemonic('r');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToleranceDialog.this.redField.setText("0");
                ToleranceDialog.this.greenField.setText("0");
                ToleranceDialog.this.blueField.setText("0");
                ToleranceDialog.this.alphaField.setText("0");
            }
        });
        this.addLeftButton(jButton);
    }

    public void approve() {
        int n = Util.asInt(this.redField.getText().trim());
        int n2 = Util.asInt(this.greenField.getText().trim());
        int n3 = Util.asInt(this.blueField.getText().trim());
        int n4 = Util.asInt(this.alphaField.getText().trim());
        FillTool.INSTANCE.setTolerance(new FillTool.Tolerance(n, n2, n3, n4));
        super.approve();
    }

    private void checkInput() {
        String[] stringArray = new String[]{this.redField.getText().trim(), this.greenField.getText().trim(), this.blueField.getText().trim(), this.alphaField.getText().trim()};
        boolean bl = true;
        for (int i = 0; i < 4; ++i) {
            if (Util.isNumber(stringArray[i]) && Util.isIn(Util.asInt(stringArray[i]), 0, 255)) continue;
            bl = false;
        }
        this.getApproveButton().setEnabled(bl);
    }

    private void update(Document document) {
        this.checkInput();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent.getDocument());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent.getDocument());
    }
}

