/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.Util;

public final class ResourceFinder {
    private static final String FILE = "file:";
    private static final String JAR = "jar:";
    private final String path;
    private final ArrayList files = new ArrayList();
    private final boolean recursive;
    private final FileFilter filter;
    private final String[] extensions;
    private String prefix;

    public ResourceFinder(String string) {
        this(string, null, true);
    }

    public ResourceFinder(String string, String[] stringArray) {
        this(string, stringArray, true);
    }

    public ResourceFinder(String string, String[] stringArray, boolean bl) {
        this.path = string;
        this.recursive = bl;
        this.extensions = stringArray;
        this.filter = new Filter();
    }

    public String[] findResources() {
        try {
            this.files.clear();
            this.prefix = new String(this.path);
            URL uRL = this.getClass().getClassLoader().getResource(this.path);
            if (uRL == null && File.separatorChar == '\\') {
                this.prefix = this.path.replace(File.separatorChar, '/');
                uRL = this.getClass().getClassLoader().getResource(this.prefix);
            }
            this.findResources(uRL);
            int n = this.files.size();
            if (n == 0) {
                return null;
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.files.get(i).toString();
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
            return null;
        }
    }

    public String getPath() {
        return this.prefix;
    }

    private void findResources(URL uRL) throws Exception {
        if (uRL == null) {
            Log.warning("path '" + this.path + "' not found");
            return;
        }
        String string = uRL.toString();
        if (string.startsWith(JAR)) {
            if (File.separatorChar == '\\') {
                this.prefix = this.path.replace(File.separatorChar, '/');
            }
            this.findJarResources(uRL);
        } else if (string.startsWith(FILE)) {
            if (File.separatorChar == '\\') {
                this.prefix = this.path.replace('/', '\\');
            }
            this.findFileResources(uRL);
        } else {
            Log.warning("cannot handle " + uRL);
        }
    }

    private String convert(String string) {
        try {
            string = URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findJarResources(URL uRL) throws IOException {
        String string = uRL.toString().substring(JAR.length());
        int n = (string = string.substring(FILE.length())).indexOf(33);
        Assert.isTrue(n != -1, "Invalid jar url " + uRL.toString());
        String string2 = string.substring(0, n);
        if (File.separatorChar == '\\') {
            string2 = string2.substring(1);
        }
        JarFile jarFile = null;
        try {
            char c = string2.charAt(0);
            while (!Character.isLetter(c) && c != '/' && c != '\\') {
                string2 = string2.substring(1);
                c = string2.charAt(0);
            }
            string2 = this.convert(string2);
            Log.info("opening jar file '" + string2 + "'");
            jarFile = new JarFile(string2);
            String string3 = string.substring(n + 1);
            if (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string4 = ((Object)enumeration.nextElement()).toString();
                if (string4.endsWith("/") || !string4.startsWith(string3)) continue;
                this.files.add(string4);
            }
        }
        catch (Throwable throwable) {
            Util.close(jarFile);
            throw throwable;
        }
        Util.close(jarFile);
    }

    private void findFileResources(URL uRL) {
        this.findFilesInDirectory(new File(uRL.toString().substring(FILE.length())));
    }

    private void findFilesInDirectory(File file) {
        File[] fileArray = file.listFiles(this.filter);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.findFilesInDirectory(file2);
                continue;
            }
            this.files.add(file2.toString());
        }
    }

    private class Filter
    implements FileFilter {
        private Filter() {
        }

        public final boolean accept(File file) {
            if (file.isDirectory()) {
                return ResourceFinder.this.recursive;
            }
            if (ResourceFinder.this.extensions == null) {
                return true;
            }
            String string = file.toString();
            for (int i = 0; i < ResourceFinder.this.extensions.length; ++i) {
                if (!string.endsWith(ResourceFinder.this.extensions[i])) continue;
                return true;
            }
            return false;
        }
    }
}

